/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.catchup.tx;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.IOException;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.neo4j.causalclustering.catchup.CatchupResult;
import org.neo4j.causalclustering.catchup.CatchupServerProtocol;
import org.neo4j.causalclustering.catchup.ResponseMessageType;
import org.neo4j.causalclustering.catchup.tx.ChunkedTransactionStream;
import org.neo4j.causalclustering.catchup.tx.TxPullRequest;
import org.neo4j.causalclustering.catchup.tx.TxPullRequestsMonitor;
import org.neo4j.causalclustering.catchup.tx.TxStreamFinishedResponse;
import org.neo4j.causalclustering.identity.StoreId;
import org.neo4j.cursor.IOCursor;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.kernel.NeoStoreDataSource;
import org.neo4j.kernel.impl.transaction.CommittedTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchTransactionException;
import org.neo4j.kernel.impl.transaction.log.TransactionCursor;
import org.neo4j.kernel.impl.transaction.log.TransactionIdStore;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class TxPullRequestHandler
extends SimpleChannelInboundHandler<TxPullRequest> {
    private final CatchupServerProtocol protocol;
    private final Supplier<StoreId> storeIdSupplier;
    private final BooleanSupplier databaseAvailable;
    private final TransactionIdStore transactionIdStore;
    private final LogicalTransactionStore logicalTransactionStore;
    private final TxPullRequestsMonitor monitor;
    private final Log log;

    public TxPullRequestHandler(CatchupServerProtocol protocol, Supplier<StoreId> storeIdSupplier, BooleanSupplier databaseAvailable, Supplier<NeoStoreDataSource> dataSourceSupplier, Monitors monitors, LogProvider logProvider) {
        this.protocol = protocol;
        this.storeIdSupplier = storeIdSupplier;
        this.databaseAvailable = databaseAvailable;
        DependencyResolver dependencies = dataSourceSupplier.get().getDependencyResolver();
        this.transactionIdStore = (TransactionIdStore)dependencies.resolveDependency(TransactionIdStore.class);
        this.logicalTransactionStore = (LogicalTransactionStore)dependencies.resolveDependency(LogicalTransactionStore.class);
        this.monitor = (TxPullRequestsMonitor)monitors.newMonitor(TxPullRequestsMonitor.class, new String[0]);
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    protected void channelRead0(ChannelHandlerContext ctx, TxPullRequest msg) throws Exception {
        this.monitor.increment();
        Prepare prepare = this.prepareRequest(msg);
        if (prepare.isComplete()) {
            prepare.complete(ctx);
            this.protocol.expect(CatchupServerProtocol.State.MESSAGE_TYPE);
            return;
        }
        TxPullingContext txPullingContext = prepare.txPullingContext();
        ChunkedTransactionStream txStream = new ChunkedTransactionStream(this.log, txPullingContext.localStoreId, txPullingContext.firstTxId, txPullingContext.txIdPromise, (IOCursor<CommittedTransactionRepresentation>)txPullingContext.transactions, this.protocol);
        ctx.writeAndFlush((Object)txStream).addListener(f -> {
            if (this.log.isDebugEnabled() || !f.isSuccess()) {
                String message = String.format("Streamed transactions [%d--%d] to %s", txPullingContext.firstTxId, txStream.lastTxId(), ctx.channel().remoteAddress());
                if (f.isSuccess()) {
                    this.log.debug(message);
                } else {
                    this.log.warn(message, f.cause());
                }
            }
        });
    }

    private Prepare prepareRequest(TxPullRequest msg) throws IOException {
        long txIdPromise;
        long firstTxId = msg.previousTxId() + 1L;
        if (msg.previousTxId() <= 0L) {
            this.log.error("Illegal tx pull request. Tx id must be greater than 0");
            return Prepare.fail(CatchupResult.E_INVALID_REQUEST);
        }
        if (!this.databaseAvailable.getAsBoolean()) {
            this.log.info("Failed to serve TxPullRequest for tx %d because the local database is unavailable.", new Object[]{firstTxId});
            return Prepare.fail(CatchupResult.E_STORE_UNAVAILABLE);
        }
        StoreId expectedStoreId = msg.expectedStoreId();
        StoreId localStoreId = this.storeIdSupplier.get();
        if (localStoreId == null || !localStoreId.equals(expectedStoreId)) {
            this.log.info("Failed to serve TxPullRequest for tx %d and storeId %s because that storeId is different from this machine with %s", new Object[]{firstTxId, expectedStoreId, localStoreId});
            return Prepare.fail(CatchupResult.E_STORE_ID_MISMATCH);
        }
        try {
            txIdPromise = this.transactionIdStore.getLastCommittedTransactionId();
        }
        catch (RuntimeException e) {
            this.log.info("Failed to serve TxPullRequest. Reason: %s", new Object[]{e.getMessage()});
            return Prepare.fail(CatchupResult.E_STORE_UNAVAILABLE);
        }
        if (txIdPromise < firstTxId) {
            return Prepare.nothingToSend(txIdPromise);
        }
        try {
            TransactionCursor transactions = this.logicalTransactionStore.getTransactions(firstTxId);
            if (transactions == null) {
                this.log.info("Unable to get transaction cursor from logical transaction store");
                Prepare.fail(CatchupResult.E_STORE_UNAVAILABLE);
            }
            return Prepare.readyToSend(new TxPullingContext(transactions, localStoreId, firstTxId, txIdPromise));
        }
        catch (NoSuchTransactionException e) {
            this.log.info("Failed to serve TxPullRequest for tx %d because the transaction does not exist.", new Object[]{firstTxId});
            return Prepare.fail(CatchupResult.E_TRANSACTION_PRUNED);
        }
    }

    private static class Prepare {
        private final CatchupResult catchupResult;
        private final long txId;
        private final TxPullingContext txPullingContext;

        private Prepare(CatchupResult catchupResult, long txId, TxPullingContext txPullingContext) {
            this.catchupResult = catchupResult;
            this.txId = txId;
            this.txPullingContext = txPullingContext;
        }

        static Prepare fail(CatchupResult catchupResult) {
            return new Prepare(catchupResult, -1L, null);
        }

        static Prepare readyToSend(TxPullingContext txPullingContext) {
            return new Prepare(null, txPullingContext.txIdPromise, txPullingContext);
        }

        static Prepare nothingToSend(long txIdPromise) {
            return new Prepare(CatchupResult.SUCCESS_END_OF_STREAM, txIdPromise, null);
        }

        public boolean isComplete() {
            return this.catchupResult != null;
        }

        private void complete(ChannelHandlerContext ctx) {
            if (this.catchupResult == null) {
                throw new IllegalStateException("Cannot complete catchup request.");
            }
            ctx.write((Object)ResponseMessageType.TX_STREAM_FINISHED);
            ctx.writeAndFlush((Object)new TxStreamFinishedResponse(this.catchupResult, this.txId));
        }

        TxPullingContext txPullingContext() {
            return this.txPullingContext;
        }
    }

    private static class TxPullingContext {
        private final TransactionCursor transactions;
        private final StoreId localStoreId;
        private final long firstTxId;
        private final long txIdPromise;

        TxPullingContext(TransactionCursor transactions, StoreId localStoreId, long firstTxId, long txIdPromise) {
            this.transactions = transactions;
            this.localStoreId = localStoreId;
            this.firstTxId = firstTxId;
            this.txIdPromise = txIdPromise;
        }
    }
}

