/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import org.neo4j.causalclustering.core.BoundedPriorityQueue;
import org.neo4j.causalclustering.core.consensus.ContinuousJob;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.messaging.ComposableMessageHandler;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.helpers.ArrayUtil;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class BatchingMessageHandler
implements Runnable,
LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> {
    private final LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> handler;
    private final Log log;
    private final BoundedPriorityQueue<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> inQueue;
    private final ContinuousJob job;
    private final List<ReplicatedContent> contentBatch;
    private final List<RaftLogEntry> entryBatch;
    private final Config batchConfig;
    private volatile boolean stopped;
    private volatile BoundedPriorityQueue.Result lastResult = BoundedPriorityQueue.Result.OK;
    private AtomicLong droppedCount = new AtomicLong();

    BatchingMessageHandler(LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> handler, BoundedPriorityQueue.Config inQueueConfig, Config batchConfig, Function<Runnable, ContinuousJob> jobFactory, LogProvider logProvider) {
        this.handler = handler;
        this.log = logProvider.getLog(this.getClass());
        this.batchConfig = batchConfig;
        this.contentBatch = new ArrayList<ReplicatedContent>(batchConfig.maxBatchCount);
        this.entryBatch = new ArrayList<RaftLogEntry>(batchConfig.maxBatchCount);
        this.inQueue = new BoundedPriorityQueue<RaftMessages.ReceivedInstantClusterIdAwareMessage>(inQueueConfig, ContentSize::of, new MessagePriority());
        this.job = jobFactory.apply(this);
    }

    static ComposableMessageHandler composable(BoundedPriorityQueue.Config inQueueConfig, Config batchConfig, Function<Runnable, ContinuousJob> jobSchedulerFactory, LogProvider logProvider) {
        return delegate -> new BatchingMessageHandler(delegate, inQueueConfig, batchConfig, jobSchedulerFactory, logProvider);
    }

    @Override
    public void start(ClusterId clusterId) throws Throwable {
        this.handler.start(clusterId);
        this.job.start();
    }

    @Override
    public void stop() throws Throwable {
        this.stopped = true;
        this.handler.stop();
        this.job.stop();
    }

    @Override
    public void handle(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> message) {
        if (this.stopped) {
            this.log.debug("This handler has been stopped, dropping the message: %s", new Object[]{message});
            return;
        }
        BoundedPriorityQueue.Result result = this.inQueue.offer(message);
        this.logQueueState(result);
    }

    private void logQueueState(BoundedPriorityQueue.Result result) {
        if (result != BoundedPriorityQueue.Result.OK) {
            this.droppedCount.incrementAndGet();
        }
        if (result != this.lastResult) {
            if (result == BoundedPriorityQueue.Result.OK) {
                this.log.info("Raft in-queue not dropping messages anymore. Dropped %d messages.", new Object[]{this.droppedCount.getAndSet(0L)});
            } else {
                this.log.warn("Raft in-queue dropping messages after: " + (Object)((Object)result));
            }
            this.lastResult = result;
        }
    }

    @Override
    public void run() {
        Optional<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> baseMessage;
        try {
            baseMessage = this.inQueue.poll(1, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.log.warn("Not expecting to be interrupted.", (Throwable)e);
            return;
        }
        if (!baseMessage.isPresent()) {
            return;
        }
        RaftMessages.ReceivedInstantClusterIdAwareMessage<?> batchedMessage = baseMessage.get().message().dispatch(new BatchingHandler(baseMessage.get()));
        this.handler.handle(batchedMessage == null ? baseMessage.get() : batchedMessage);
    }

    private RaftMessages.NewEntry.BatchRequest batchNewEntries(RaftMessages.NewEntry.Request first) {
        ReplicatedContent content;
        Optional<BoundedPriorityQueue.Removable<RaftMessages.NewEntry.Request>> peeked;
        this.contentBatch.clear();
        this.contentBatch.add(first.content());
        long totalBytes = first.content().size().orElse(0L);
        while (this.contentBatch.size() < this.batchConfig.maxBatchCount && (peeked = this.peekNext(RaftMessages.NewEntry.Request.class)).isPresent() && (!(content = peeked.get().get().content()).size().isPresent() || totalBytes + content.size().getAsLong() <= this.batchConfig.maxBatchBytes)) {
            this.contentBatch.add(content);
            boolean removed = peeked.get().remove();
            assert (removed);
        }
        return new RaftMessages.NewEntry.BatchRequest(this.contentBatch);
    }

    private RaftMessages.AppendEntries.Request batchAppendEntries(RaftMessages.AppendEntries.Request first) {
        RaftMessages.AppendEntries.Request request;
        Optional<BoundedPriorityQueue.Removable<RaftMessages.AppendEntries.Request>> peeked;
        this.entryBatch.clear();
        long totalBytes = 0L;
        for (RaftLogEntry entry2 : first.entries()) {
            totalBytes += entry2.content().size().orElse(0L);
            this.entryBatch.add(entry2);
        }
        long leaderCommit = first.leaderCommit();
        long lastTerm = ((RaftLogEntry)ArrayUtil.lastOf((Object[])first.entries())).term();
        while (this.entryBatch.size() < this.batchConfig.maxBatchCount && (peeked = this.peekNext(RaftMessages.AppendEntries.Request.class)).isPresent() && (request = peeked.get().get()).entries().length != 0 && this.consecutiveOrigin(first, request, this.entryBatch.size())) {
            long requestBytes;
            assert (lastTerm == request.prevLogTerm());
            Object[] entries = request.entries();
            lastTerm = ((RaftLogEntry)ArrayUtil.lastOf((Object[])entries)).term();
            if (entries.length + this.entryBatch.size() > this.batchConfig.maxBatchCount || (requestBytes = Arrays.stream(entries).mapToLong(entry -> entry.content().size().orElse(0L)).sum()) > 0L && totalBytes + requestBytes > this.batchConfig.maxBatchBytes) break;
            this.entryBatch.addAll(Arrays.asList(entries));
            totalBytes += requestBytes;
            leaderCommit = Long.max(leaderCommit, request.leaderCommit());
            boolean removed = peeked.get().remove();
            assert (removed);
        }
        return new RaftMessages.AppendEntries.Request(first.from(), first.leaderTerm(), first.prevLogIndex(), first.prevLogTerm(), this.entryBatch.toArray(RaftLogEntry.empty), leaderCommit);
    }

    private boolean consecutiveOrigin(RaftMessages.AppendEntries.Request first, RaftMessages.AppendEntries.Request request, int currentSize) {
        if (request.leaderTerm() != first.leaderTerm()) {
            return false;
        }
        return request.prevLogIndex() == first.prevLogIndex() + (long)currentSize;
    }

    private <M> Optional<BoundedPriorityQueue.Removable<M>> peekNext(Class<M> acceptedType) {
        return this.inQueue.peek().filter(r -> acceptedType.isInstance(((RaftMessages.ReceivedInstantClusterIdAwareMessage)r.get()).message())).map(r -> r.map(m -> acceptedType.cast(m.message())));
    }

    private class BatchingHandler
    extends RaftMessages.HandlerAdaptor<RaftMessages.ReceivedInstantClusterIdAwareMessage, RuntimeException> {
        private final RaftMessages.ReceivedInstantClusterIdAwareMessage<?> baseMessage;

        BatchingHandler(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> baseMessage) {
            this.baseMessage = baseMessage;
        }

        @Override
        public RaftMessages.ReceivedInstantClusterIdAwareMessage handle(RaftMessages.NewEntry.Request request) throws RuntimeException {
            RaftMessages.NewEntry.BatchRequest newEntryBatch = BatchingMessageHandler.this.batchNewEntries(request);
            return RaftMessages.ReceivedInstantClusterIdAwareMessage.of(this.baseMessage.receivedAt(), this.baseMessage.clusterId(), newEntryBatch);
        }

        @Override
        public RaftMessages.ReceivedInstantClusterIdAwareMessage handle(RaftMessages.AppendEntries.Request request) throws RuntimeException {
            if (request.entries().length == 0) {
                return null;
            }
            RaftMessages.AppendEntries.Request appendEntriesBatch = BatchingMessageHandler.this.batchAppendEntries(request);
            return RaftMessages.ReceivedInstantClusterIdAwareMessage.of(this.baseMessage.receivedAt(), this.baseMessage.clusterId(), appendEntriesBatch);
        }
    }

    private class MessagePriority
    extends RaftMessages.HandlerAdaptor<Integer, RuntimeException>
    implements Comparator<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> {
        private final Integer BASE_PRIORITY = 10;

        private MessagePriority() {
        }

        @Override
        public Integer handle(RaftMessages.AppendEntries.Request request) {
            return request.entries().length == 0 ? this.BASE_PRIORITY : 20;
        }

        @Override
        public Integer handle(RaftMessages.NewEntry.Request request) {
            return 30;
        }

        @Override
        public int compare(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> messageA, RaftMessages.ReceivedInstantClusterIdAwareMessage<?> messageB) {
            int priorityA = this.getPriority(messageA);
            int priorityB = this.getPriority(messageB);
            return Integer.compare(priorityA, priorityB);
        }

        private int getPriority(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> message) {
            Integer priority = message.dispatch(this);
            return priority == null ? this.BASE_PRIORITY : priority;
        }
    }

    private static class ContentSize
    extends RaftMessages.HandlerAdaptor<Long, RuntimeException> {
        private static final ContentSize INSTANCE = new ContentSize();

        private ContentSize() {
        }

        static long of(RaftMessages.ReceivedInstantClusterIdAwareMessage<?> message) {
            Long dispatch = message.dispatch(INSTANCE);
            return dispatch == null ? 0L : dispatch;
        }

        @Override
        public Long handle(RaftMessages.NewEntry.Request request) throws RuntimeException {
            return request.content().size().orElse(0L);
        }

        @Override
        public Long handle(RaftMessages.AppendEntries.Request request) throws RuntimeException {
            long totalSize = 0L;
            for (RaftLogEntry entry : request.entries()) {
                if (!entry.content().size().isPresent()) continue;
                totalSize += entry.content().size().getAsLong();
            }
            return totalSize;
        }
    }

    public static class Config {
        private final int maxBatchCount;
        private final long maxBatchBytes;

        Config(int maxBatchCount, long maxBatchBytes) {
            this.maxBatchCount = maxBatchCount;
            this.maxBatchBytes = maxBatchBytes;
        }
    }
}

