/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.io.File;
import java.util.function.Function;
import org.neo4j.causalclustering.core.EnterpriseCoreEditionModule;
import org.neo4j.causalclustering.core.consensus.RaftMachine;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.graphdb.facade.GraphDatabaseFacadeFactory;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.DatabaseInfo;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;

public class CoreGraphDatabase
extends GraphDatabaseFacade {
    private EnterpriseCoreEditionModule editionModule;

    protected CoreGraphDatabase() {
    }

    public CoreGraphDatabase(File storeDir, Config config, GraphDatabaseFacadeFactory.Dependencies dependencies, DiscoveryServiceFactory discoveryServiceFactory) {
        Function<PlatformModule, AbstractEditionModule> factory = platformModule -> {
            this.editionModule = new EnterpriseCoreEditionModule((PlatformModule)platformModule, discoveryServiceFactory);
            return this.editionModule;
        };
        new GraphDatabaseFacadeFactory(DatabaseInfo.CORE, factory).initFacade(storeDir, config, dependencies, (GraphDatabaseFacade)this);
    }

    public Role getRole() {
        return ((RaftMachine)this.getDependencyResolver().resolveDependency(RaftMachine.class)).currentRole();
    }

    public void disableCatchupServer() throws Throwable {
        this.editionModule.disableCatchupServer();
    }
}

