/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacade;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class IdFilesSanitationModule
extends LifecycleAdapter {
    private final Supplier<DatabaseManager> databaseManagerSupplier;
    private final FileSystemAbstraction fileSystem;
    private final Log log;
    private final boolean unboundOnCreation;

    IdFilesSanitationModule(boolean wasUnboundOnCreation, Supplier<DatabaseManager> databaseManagerSupplier, FileSystemAbstraction fileSystem, LogProvider logProvider) {
        this.unboundOnCreation = wasUnboundOnCreation;
        this.databaseManagerSupplier = databaseManagerSupplier;
        this.fileSystem = fileSystem;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
    }

    public void start() throws Throwable {
        if (!this.unboundOnCreation) {
            return;
        }
        DatabaseManager databaseManager = this.databaseManagerSupplier.get();
        for (String databaseName : databaseManager.listDatabases()) {
            Optional database = databaseManager.getDatabaseFacade(databaseName);
            database.ifPresent(db -> this.deleteIdFiles(databaseName, (GraphDatabaseFacade)db));
        }
    }

    private void deleteIdFiles(String databaseName, GraphDatabaseFacade db) {
        if (this.deleteIdFiles(db.databaseLayout())) {
            this.log.info(String.format("ID-files deleted for %s", databaseName));
        }
    }

    private boolean deleteIdFiles(DatabaseLayout databaseLayout) {
        if (!this.fileSystem.fileExists(databaseLayout.databaseDirectory())) {
            return false;
        }
        boolean anyIdFilesDeleted = false;
        for (File idFile : databaseLayout.idFiles()) {
            try {
                if (this.fileSystem.fileExists(idFile)) {
                    this.fileSystem.deleteFileOrThrow(idFile);
                }
                anyIdFilesDeleted = true;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not delete ID-file", e);
            }
        }
        return anyIdFilesDeleted;
    }
}

