/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core;

import io.netty.channel.ChannelInboundHandler;
import java.time.Clock;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import org.neo4j.causalclustering.catchup.CatchupAddressProvider;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.BatchingMessageHandler;
import org.neo4j.causalclustering.core.BoundedPriorityQueue;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.ClusterBindingHandler;
import org.neo4j.causalclustering.core.IdentityModule;
import org.neo4j.causalclustering.core.consensus.ConsensusModule;
import org.neo4j.causalclustering.core.consensus.ContinuousJob;
import org.neo4j.causalclustering.core.consensus.LeaderAvailabilityHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessageMonitoringHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessageNettyHandler;
import org.neo4j.causalclustering.core.consensus.RaftMessageTimerResetMonitor;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.protocol.v1.RaftProtocolServerInstallerV1;
import org.neo4j.causalclustering.core.consensus.protocol.v2.RaftProtocolServerInstallerV2;
import org.neo4j.causalclustering.core.server.CoreServerModule;
import org.neo4j.causalclustering.core.state.RaftMessageApplier;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.logging.MessageLogger;
import org.neo4j.causalclustering.messaging.ComposableMessageHandler;
import org.neo4j.causalclustering.messaging.LifecycleMessageHandler;
import org.neo4j.causalclustering.messaging.LoggingInbound;
import org.neo4j.causalclustering.net.Server;
import org.neo4j.causalclustering.protocol.ModifierProtocolInstaller;
import org.neo4j.causalclustering.protocol.NettyPipelineBuilderFactory;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.ProtocolInstaller;
import org.neo4j.causalclustering.protocol.ProtocolInstallerRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ApplicationSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.HandshakeServerInitializer;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.helpers.ListenSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;

public class RaftServerModule {
    public static final String RAFT_SERVER_NAME = "raft-server";
    private final PlatformModule platformModule;
    private final ConsensusModule consensusModule;
    private final IdentityModule identityModule;
    private final ApplicationSupportedProtocols supportedApplicationProtocol;
    private final LocalDatabase localDatabase;
    private final MessageLogger<MemberId> messageLogger;
    private final LogProvider logProvider;
    private final NettyPipelineBuilderFactory pipelineBuilderFactory;
    private CatchupAddressProvider.PrioritisingUpstreamStrategyBasedAddressProvider catchupAddressProvider;
    private final Collection<ModifierSupportedProtocols> supportedModifierProtocols;

    private RaftServerModule(PlatformModule platformModule, ConsensusModule consensusModule, IdentityModule identityModule, CoreServerModule coreServerModule, LocalDatabase localDatabase, NettyPipelineBuilderFactory pipelineBuilderFactory, MessageLogger<MemberId> messageLogger, CatchupAddressProvider.PrioritisingUpstreamStrategyBasedAddressProvider catchupAddressProvider, ApplicationSupportedProtocols supportedApplicationProtocol, Collection<ModifierSupportedProtocols> supportedModifierProtocols, ChannelInboundHandler installedProtocolsHandler) {
        this.platformModule = platformModule;
        this.consensusModule = consensusModule;
        this.identityModule = identityModule;
        this.supportedApplicationProtocol = supportedApplicationProtocol;
        this.localDatabase = localDatabase;
        this.messageLogger = messageLogger;
        this.logProvider = platformModule.logging.getInternalLogProvider();
        this.pipelineBuilderFactory = pipelineBuilderFactory;
        this.catchupAddressProvider = catchupAddressProvider;
        this.supportedModifierProtocols = supportedModifierProtocols;
        LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> messageHandlerChain = this.createMessageHandlerChain(coreServerModule);
        this.createRaftServer(coreServerModule, messageHandlerChain, installedProtocolsHandler);
    }

    static void createAndStart(PlatformModule platformModule, ConsensusModule consensusModule, IdentityModule identityModule, CoreServerModule coreServerModule, LocalDatabase localDatabase, NettyPipelineBuilderFactory pipelineBuilderFactory, MessageLogger<MemberId> messageLogger, CatchupAddressProvider.PrioritisingUpstreamStrategyBasedAddressProvider addressProvider, ApplicationSupportedProtocols supportedApplicationProtocol, Collection<ModifierSupportedProtocols> supportedModifierProtocols, ChannelInboundHandler installedProtocolsHandler) {
        new RaftServerModule(platformModule, consensusModule, identityModule, coreServerModule, localDatabase, pipelineBuilderFactory, messageLogger, addressProvider, supportedApplicationProtocol, supportedModifierProtocols, installedProtocolsHandler);
    }

    private void createRaftServer(CoreServerModule coreServerModule, LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> messageHandlerChain, ChannelInboundHandler installedProtocolsHandler) {
        ApplicationProtocolRepository applicationProtocolRepository = new ApplicationProtocolRepository(Protocol.ApplicationProtocols.values(), this.supportedApplicationProtocol);
        ModifierProtocolRepository modifierProtocolRepository = new ModifierProtocolRepository(Protocol.ModifierProtocols.values(), this.supportedModifierProtocols);
        RaftMessageNettyHandler nettyHandler = new RaftMessageNettyHandler(this.logProvider);
        RaftProtocolServerInstallerV2.Factory raftProtocolServerInstallerV2 = new RaftProtocolServerInstallerV2.Factory((ChannelInboundHandler)nettyHandler, this.pipelineBuilderFactory, this.logProvider);
        RaftProtocolServerInstallerV1.Factory raftProtocolServerInstallerV1 = new RaftProtocolServerInstallerV1.Factory((ChannelInboundHandler)nettyHandler, this.pipelineBuilderFactory, this.logProvider);
        ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server> protocolInstallerRepository = new ProtocolInstallerRepository<ProtocolInstaller.Orientation.Server>(Arrays.asList(raftProtocolServerInstallerV1, raftProtocolServerInstallerV2), ModifierProtocolInstaller.allServerInstallers);
        HandshakeServerInitializer handshakeServerInitializer = new HandshakeServerInitializer(applicationProtocolRepository, modifierProtocolRepository, protocolInstallerRepository, this.pipelineBuilderFactory, this.logProvider);
        ListenSocketAddress raftListenAddress = (ListenSocketAddress)this.platformModule.config.get(CausalClusteringSettings.raft_listen_address);
        Server raftServer = new Server(handshakeServerInitializer, installedProtocolsHandler, this.logProvider, this.platformModule.logging.getUserLogProvider(), raftListenAddress, RAFT_SERVER_NAME);
        this.platformModule.dependencies.satisfyDependency((Object)raftServer);
        LoggingInbound loggingRaftInbound = new LoggingInbound(nettyHandler, this.messageLogger, this.identityModule.myself());
        loggingRaftInbound.registerHandler(messageHandlerChain);
        this.platformModule.life.add((Lifecycle)raftServer);
        this.platformModule.life.add((Lifecycle)coreServerModule.createCoreLife(messageHandlerChain));
        this.platformModule.life.add((Lifecycle)coreServerModule.catchupServer());
        coreServerModule.backupServer().ifPresent(arg_0 -> ((LifeSupport)this.platformModule.life).add(arg_0));
        this.platformModule.life.add((Lifecycle)coreServerModule.downloadService());
    }

    private LifecycleMessageHandler<RaftMessages.ReceivedInstantClusterIdAwareMessage<?>> createMessageHandlerChain(CoreServerModule coreServerModule) {
        RaftMessageApplier messageApplier = new RaftMessageApplier(this.localDatabase, this.logProvider, this.consensusModule.raftMachine(), coreServerModule.downloadService(), coreServerModule.commandApplicationProcess(), this.catchupAddressProvider);
        ComposableMessageHandler monitoringHandler = RaftMessageMonitoringHandler.composable((Clock)this.platformModule.clock, this.platformModule.monitors);
        ComposableMessageHandler batchingMessageHandler = this.createBatchingHandler(this.platformModule.config);
        ComposableMessageHandler leaderAvailabilityHandler = LeaderAvailabilityHandler.composable(this.consensusModule.getLeaderAvailabilityTimers(), (RaftMessageTimerResetMonitor)this.platformModule.monitors.newMonitor(RaftMessageTimerResetMonitor.class, new String[0]), this.consensusModule.raftMachine()::term);
        ComposableMessageHandler clusterBindingHandler = ClusterBindingHandler.composable(this.logProvider);
        return (LifecycleMessageHandler)clusterBindingHandler.compose(leaderAvailabilityHandler).compose(batchingMessageHandler).compose(monitoringHandler).apply(messageApplier);
    }

    private ComposableMessageHandler createBatchingHandler(Config config) {
        Function<Runnable, ContinuousJob> jobFactory = runnable -> new ContinuousJob(this.platformModule.jobScheduler.threadFactory(Group.RAFT_BATCH_HANDLER), (Runnable)runnable, this.logProvider);
        BoundedPriorityQueue.Config inQueueConfig = new BoundedPriorityQueue.Config((Integer)config.get(CausalClusteringSettings.raft_in_queue_size), (Long)config.get(CausalClusteringSettings.raft_in_queue_max_bytes));
        BatchingMessageHandler.Config batchConfig = new BatchingMessageHandler.Config((Integer)config.get(CausalClusteringSettings.raft_in_queue_max_batch), (Long)config.get(CausalClusteringSettings.raft_in_queue_max_batch_bytes));
        return BatchingMessageHandler.composable(inQueueConfig, batchConfig, jobFactory, this.logProvider);
    }
}

