/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log;

import java.io.IOException;
import org.neo4j.causalclustering.core.consensus.log.DelegatingRaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLog;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.monitoring.RaftLogAppendIndexMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class MonitoredRaftLog
extends DelegatingRaftLog {
    private final RaftLogAppendIndexMonitor appendIndexMonitor;

    public MonitoredRaftLog(RaftLog delegate, Monitors monitors) {
        super(delegate);
        this.appendIndexMonitor = (RaftLogAppendIndexMonitor)monitors.newMonitor(RaftLogAppendIndexMonitor.class, new String[]{this.getClass().getName()});
    }

    @Override
    public long append(RaftLogEntry ... entries) throws IOException {
        long appendIndex = super.append(entries);
        this.appendIndexMonitor.appendIndex(appendIndex);
        return appendIndex;
    }

    @Override
    public void truncate(long fromIndex) throws IOException {
        super.truncate(fromIndex);
        this.appendIndexMonitor.appendIndex(super.appendIndex());
    }
}

