/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.cache;

import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCacheMonitor;

public class ConsecutiveInFlightCache
implements InFlightCache {
    private final ConsecutiveCache<RaftLogEntry> cache;
    private final RaftLogEntry[] evictions;
    private final InFlightCacheMonitor monitor;
    private long totalBytes;
    private long maxBytes;
    private boolean enabled;

    public ConsecutiveInFlightCache() {
        this(1024, 0x800000L, InFlightCacheMonitor.VOID, true);
    }

    public ConsecutiveInFlightCache(int capacity, long maxBytes, InFlightCacheMonitor monitor, boolean enabled) {
        this.cache = new ConsecutiveCache(capacity);
        this.evictions = new RaftLogEntry[capacity];
        this.maxBytes = maxBytes;
        this.monitor = monitor;
        this.enabled = enabled;
        monitor.setMaxBytes(maxBytes);
        monitor.setMaxElements(capacity);
    }

    @Override
    public synchronized void enable() {
        this.enabled = true;
    }

    @Override
    public synchronized void put(long logIndex, RaftLogEntry entry) {
        if (!this.enabled) {
            return;
        }
        this.totalBytes += this.sizeOf(entry);
        this.cache.put(logIndex, entry, (RaftLogEntry[])this.evictions);
        this.processEvictions();
        while (this.totalBytes > this.maxBytes) {
            RaftLogEntry evicted = this.cache.remove();
            this.totalBytes -= this.sizeOf(evicted);
        }
    }

    @Override
    public synchronized RaftLogEntry get(long logIndex) {
        if (!this.enabled) {
            return null;
        }
        RaftLogEntry entry = this.cache.get(logIndex);
        if (entry == null) {
            this.monitor.miss();
        } else {
            this.monitor.hit();
        }
        return entry;
    }

    @Override
    public synchronized void truncate(long fromIndex) {
        if (!this.enabled) {
            return;
        }
        this.cache.truncate(fromIndex, (RaftLogEntry[])this.evictions);
        this.processEvictions();
    }

    @Override
    public synchronized void prune(long upToIndex) {
        if (!this.enabled) {
            return;
        }
        this.cache.prune(upToIndex, (RaftLogEntry[])this.evictions);
        this.processEvictions();
    }

    @Override
    public synchronized long totalBytes() {
        return this.totalBytes;
    }

    @Override
    public synchronized int elementCount() {
        return this.cache.size();
    }

    private long sizeOf(RaftLogEntry entry) {
        return entry.content().size().orElse(0L);
    }

    private void processEvictions() {
        RaftLogEntry entry;
        for (int i = 0; i < this.evictions.length && (entry = this.evictions[i]) != null; ++i) {
            this.evictions[i] = null;
            this.totalBytes -= this.sizeOf(entry);
        }
        this.monitor.setTotalBytes(this.totalBytes);
        this.monitor.setElementCount(this.cache.size());
    }
}

