/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.cache;

import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.log.cache.ConsecutiveInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.InFlightCacheMonitor;
import org.neo4j.causalclustering.core.consensus.log.cache.UnboundedInFlightCache;
import org.neo4j.causalclustering.core.consensus.log.cache.VoidInFlightCache;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.monitoring.Monitors;

public class InFlightCacheFactory {
    public static InFlightCache create(Config config, Monitors monitors) {
        return ((Type)((Object)config.get(CausalClusteringSettings.in_flight_cache_type))).create(config, monitors);
    }

    public static enum Type {
        NONE{

            @Override
            InFlightCache create(Config config, Monitors monitors) {
                return new VoidInFlightCache();
            }
        }
        ,
        CONSECUTIVE{

            @Override
            InFlightCache create(Config config, Monitors monitors) {
                return new ConsecutiveInFlightCache((Integer)config.get(CausalClusteringSettings.in_flight_cache_max_entries), (Long)config.get(CausalClusteringSettings.in_flight_cache_max_bytes), (InFlightCacheMonitor)monitors.newMonitor(InFlightCacheMonitor.class, new String[0]), false);
            }
        }
        ,
        UNBOUNDED{

            @Override
            InFlightCache create(Config config, Monitors monitors) {
                return new UnboundedInFlightCache();
            }
        };


        abstract InFlightCache create(Config var1, Monitors var2);
    }
}

