/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.log.segmented;

import org.neo4j.causalclustering.core.consensus.log.LogPosition;

class PositionCache {
    private static final LogPosition BEGINNING_OF_RECORDS = new LogPosition(0L, 32L);
    static final int CACHE_SIZE = 8;
    private LogPosition[] cache = new LogPosition[8];
    private int pos;

    PositionCache() {
        for (int i = 0; i < this.cache.length; ++i) {
            this.cache[i] = BEGINNING_OF_RECORDS;
        }
    }

    public synchronized void put(LogPosition position) {
        this.cache[this.pos] = position;
        this.pos = (this.pos + 1) % 8;
    }

    synchronized LogPosition lookup(long offsetIndex) {
        if (offsetIndex == 0L) {
            return BEGINNING_OF_RECORDS;
        }
        LogPosition best = BEGINNING_OF_RECORDS;
        for (int i = 0; i < 8; ++i) {
            if (this.cache[i].logIndex > offsetIndex || this.cache[i].logIndex <= best.logIndex) continue;
            best = this.cache[i];
        }
        return best;
    }
}

