/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.membership;

import java.time.Clock;
import java.util.HashSet;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.log.ReadableRaftLog;
import org.neo4j.causalclustering.core.consensus.membership.CatchupGoalTracker;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipManager;
import org.neo4j.causalclustering.core.consensus.membership.RaftMembershipStateMachineEventHandler;
import org.neo4j.causalclustering.core.consensus.roles.Role;
import org.neo4j.causalclustering.core.consensus.roles.follower.FollowerStates;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class RaftMembershipChanger {
    private final Log log;
    public RaftMembershipStateMachineEventHandler state = new Inactive();
    private final ReadableRaftLog raftLog;
    private final Clock clock;
    private final long electionTimeout;
    private final RaftMembershipManager membershipManager;
    private long catchupTimeout;
    private MemberId catchingUpMember;

    RaftMembershipChanger(ReadableRaftLog raftLog, Clock clock, long electionTimeout, LogProvider logProvider, long catchupTimeout, RaftMembershipManager membershipManager) {
        this.raftLog = raftLog;
        this.clock = clock;
        this.electionTimeout = electionTimeout;
        this.catchupTimeout = catchupTimeout;
        this.membershipManager = membershipManager;
        this.log = logProvider.getLog(this.getClass());
    }

    private synchronized void handleState(RaftMembershipStateMachineEventHandler newState) {
        RaftMembershipStateMachineEventHandler oldState = this.state;
        this.state = newState;
        if (oldState != newState) {
            oldState.onExit();
            newState.onEntry();
            this.log.info(newState.toString());
            this.membershipManager.stateChanged();
        }
    }

    void onRole(Role role) {
        this.handleState(this.state.onRole(role));
    }

    void onRaftGroupCommitted() {
        this.handleState(this.state.onRaftGroupCommitted());
    }

    void onFollowerStateChange(FollowerStates<MemberId> followerStates) {
        this.handleState(this.state.onFollowerStateChange(followerStates));
    }

    void onMissingMember(MemberId member) {
        this.handleState(this.state.onMissingMember(member));
    }

    void onSuperfluousMember(MemberId member) {
        this.handleState(this.state.onSuperfluousMember(member));
    }

    void onTargetChanged(Set<MemberId> targetMembers) {
        this.handleState(this.state.onTargetChanged(targetMembers));
    }

    private class ConsensusInProgress
    extends ActiveBaseState {
        private ConsensusInProgress() {
        }

        @Override
        public RaftMembershipStateMachineEventHandler onRaftGroupCommitted() {
            return new Idle();
        }

        @Override
        public void onEntry() {
        }

        @Override
        public void onExit() {
            RaftMembershipChanger.this.membershipManager.removeAdditionalReplicationMember(RaftMembershipChanger.this.catchingUpMember);
            RaftMembershipChanger.this.log.info("Removing replication member: " + RaftMembershipChanger.this.catchingUpMember);
        }

        public String toString() {
            return "ConsensusInProgress{}";
        }
    }

    private class CatchingUp
    extends ActiveBaseState {
        private final CatchupGoalTracker catchupGoalTracker;
        boolean movingToConsensus;

        CatchingUp(MemberId member) {
            this.catchupGoalTracker = new CatchupGoalTracker(RaftMembershipChanger.this.raftLog, RaftMembershipChanger.this.clock, RaftMembershipChanger.this.electionTimeout, RaftMembershipChanger.this.catchupTimeout);
            RaftMembershipChanger.this.catchingUpMember = member;
        }

        @Override
        public void onEntry() {
            RaftMembershipChanger.this.membershipManager.addAdditionalReplicationMember(RaftMembershipChanger.this.catchingUpMember);
            RaftMembershipChanger.this.log.info("Adding replication member: " + RaftMembershipChanger.this.catchingUpMember);
        }

        @Override
        public void onExit() {
            if (!this.movingToConsensus) {
                RaftMembershipChanger.this.membershipManager.removeAdditionalReplicationMember(RaftMembershipChanger.this.catchingUpMember);
                RaftMembershipChanger.this.log.info("Removing replication member: " + RaftMembershipChanger.this.catchingUpMember);
            }
        }

        @Override
        public RaftMembershipStateMachineEventHandler onRole(Role role) {
            if (role != Role.LEADER) {
                return new Inactive();
            }
            return this;
        }

        @Override
        public RaftMembershipStateMachineEventHandler onFollowerStateChange(FollowerStates<MemberId> followerStates) {
            this.catchupGoalTracker.updateProgress(followerStates.get(RaftMembershipChanger.this.catchingUpMember));
            if (this.catchupGoalTracker.isFinished()) {
                if (this.catchupGoalTracker.isGoalAchieved()) {
                    HashSet<MemberId> updatedVotingMembers = new HashSet<MemberId>(RaftMembershipChanger.this.membershipManager.votingMembers());
                    updatedVotingMembers.add(RaftMembershipChanger.this.catchingUpMember);
                    RaftMembershipChanger.this.membershipManager.doConsensus(updatedVotingMembers);
                    this.movingToConsensus = true;
                    return new ConsensusInProgress();
                }
                return new Idle();
            }
            return this;
        }

        @Override
        public RaftMembershipStateMachineEventHandler onTargetChanged(Set targetMembers) {
            if (!targetMembers.contains(RaftMembershipChanger.this.catchingUpMember)) {
                return new Idle();
            }
            return this;
        }

        public String toString() {
            return String.format("CatchingUp{catchupGoalTracker=%s, catchingUpMember=%s}", this.catchupGoalTracker, RaftMembershipChanger.this.catchingUpMember);
        }
    }

    private class Idle
    extends ActiveBaseState {
        private Idle() {
        }

        @Override
        public RaftMembershipStateMachineEventHandler onMissingMember(MemberId member) {
            return new CatchingUp(member);
        }

        @Override
        public RaftMembershipStateMachineEventHandler onSuperfluousMember(MemberId member) {
            HashSet<MemberId> updatedVotingMembers = new HashSet<MemberId>(RaftMembershipChanger.this.membershipManager.votingMembers());
            updatedVotingMembers.remove(member);
            RaftMembershipChanger.this.membershipManager.doConsensus(updatedVotingMembers);
            return new ConsensusInProgress();
        }

        public String toString() {
            return "Idle{}";
        }
    }

    abstract class ActiveBaseState
    extends RaftMembershipStateMachineEventHandler.Adapter {
        ActiveBaseState() {
        }

        @Override
        public RaftMembershipStateMachineEventHandler onRole(Role role) {
            if (role != Role.LEADER) {
                return new Inactive();
            }
            return this;
        }
    }

    private class Inactive
    extends RaftMembershipStateMachineEventHandler.Adapter {
        private Inactive() {
        }

        @Override
        public RaftMembershipStateMachineEventHandler onRole(Role role) {
            if (role == Role.LEADER) {
                if (RaftMembershipChanger.this.membershipManager.uncommittedMemberChangeInLog()) {
                    return new ConsensusInProgress();
                }
                return new Idle();
            }
            return this;
        }

        public String toString() {
            return "Inactive{}";
        }
    }
}

