/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.consensus.roles;

import java.io.IOException;
import java.util.Set;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.consensus.outcome.Outcome;
import org.neo4j.causalclustering.core.consensus.state.ReadableRaftState;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.logging.Log;

public class Election {
    private Election() {
    }

    public static boolean startRealElection(ReadableRaftState ctx, Outcome outcome, Log log) throws IOException {
        Set<MemberId> currentMembers = ctx.votingMembers();
        if (currentMembers == null || !currentMembers.contains(ctx.myself())) {
            log.info("Election attempted but not started, current members are %s, I am %s", new Object[]{currentMembers, ctx.myself()});
            return false;
        }
        outcome.setNextTerm(ctx.term() + 1L);
        RaftMessages.Vote.Request voteForMe = new RaftMessages.Vote.Request(ctx.myself(), outcome.getTerm(), ctx.myself(), ctx.entryLog().appendIndex(), ctx.entryLog().readEntryTerm(ctx.entryLog().appendIndex()));
        currentMembers.stream().filter(member -> !member.equals(ctx.myself())).forEach(member -> outcome.addOutgoingMessage(new RaftMessages.Directed((MemberId)member, voteForMe)));
        outcome.setVotedFor(ctx.myself());
        log.info("Election started with vote request: %s and members: %s", new Object[]{voteForMe, currentMembers});
        return true;
    }

    public static boolean startPreElection(ReadableRaftState ctx, Outcome outcome, Log log) throws IOException {
        Set<MemberId> currentMembers = ctx.votingMembers();
        if (currentMembers == null || !currentMembers.contains(ctx.myself())) {
            log.info("Pre-election attempted but not started, current members are %s, I am %s", new Object[]{currentMembers, ctx.myself()});
            return false;
        }
        RaftMessages.PreVote.Request preVoteForMe = new RaftMessages.PreVote.Request(ctx.myself(), outcome.getTerm(), ctx.myself(), ctx.entryLog().appendIndex(), ctx.entryLog().readEntryTerm(ctx.entryLog().appendIndex()));
        currentMembers.stream().filter(member -> !member.equals(ctx.myself())).forEach(member -> outcome.addOutgoingMessage(new RaftMessages.Directed((MemberId)member, preVoteForMe)));
        log.info("Pre-election started with: %s and members: %s", new Object[]{preVoteForMe, currentMembers});
        return true;
    }
}

