/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state;

import java.io.File;
import java.time.Clock;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Supplier;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.state.CoreBootstrapper;
import org.neo4j.causalclustering.core.state.storage.SimpleFileStorage;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.discovery.DiscoveryServiceFactory;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.causalclustering.discovery.ResolutionResolverFactory;
import org.neo4j.causalclustering.discovery.TopologyServiceMultiRetryStrategy;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.identity.ClusterBinder;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.DatabaseName;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.function.ThrowingAction;
import org.neo4j.graphdb.factory.module.PlatformModule;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.util.Dependencies;
import org.neo4j.kernel.lifecycle.LifeSupport;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.Clocks;

public class ClusteringModule {
    private final CoreTopologyService topologyService;
    private final ClusterBinder clusterBinder;

    public ClusteringModule(DiscoveryServiceFactory discoveryServiceFactory, MemberId myself, PlatformModule platformModule, File clusterStateDirectory, DatabaseLayout databaseLayout, AvailabilityGuard availabilityGuard) {
        LifeSupport life = platformModule.life;
        Config config = platformModule.config;
        LogProvider logProvider = platformModule.logging.getInternalLogProvider();
        LogProvider userLogProvider = platformModule.logging.getUserLogProvider();
        Dependencies dependencies = platformModule.dependencies;
        Monitors monitors = platformModule.monitors;
        FileSystemAbstraction fileSystem = platformModule.fileSystem;
        RemoteMembersResolver remoteMembersResolver = ResolutionResolverFactory.chooseResolver(config, platformModule.logging);
        this.topologyService = discoveryServiceFactory.coreTopologyService(config, myself, platformModule.jobScheduler, logProvider, userLogProvider, remoteMembersResolver, ClusteringModule.resolveStrategy(config, logProvider), monitors, (Clock)platformModule.clock);
        life.add((Lifecycle)this.topologyService);
        dependencies.satisfyDependency((Object)this.topologyService);
        CoreBootstrapper coreBootstrapper = new CoreBootstrapper(databaseLayout, platformModule.pageCache, fileSystem, config, logProvider, platformModule.monitors);
        SimpleFileStorage<ClusterId> clusterIdStorage = new SimpleFileStorage<ClusterId>(fileSystem, clusterStateDirectory, "cluster-id", new ClusterId.Marshal(), logProvider);
        SimpleFileStorage<DatabaseName> dbNameStorage = new SimpleFileStorage<DatabaseName>(fileSystem, clusterStateDirectory, "db-name", new DatabaseName.Marshal(), logProvider);
        String dbName = (String)config.get(CausalClusteringSettings.database);
        int minimumCoreHosts = (Integer)config.get(CausalClusteringSettings.minimum_core_cluster_size_at_formation);
        Duration clusterBindingTimeout = (Duration)config.get(CausalClusteringSettings.cluster_binding_timeout);
        this.clusterBinder = new ClusterBinder(clusterIdStorage, dbNameStorage, this.topologyService, Clocks.systemClock(), (ThrowingAction<InterruptedException>)((ThrowingAction)() -> Thread.sleep(100L)), clusterBindingTimeout, coreBootstrapper, dbName, availabilityGuard, minimumCoreHosts, platformModule.monitors);
    }

    private static TopologyServiceRetryStrategy resolveStrategy(Config config, LogProvider logProvider) {
        long refreshPeriodMillis = ((Duration)config.get(CausalClusteringSettings.cluster_topology_refresh)).toMillis();
        int pollingFrequencyWithinRefreshWindow = 2;
        int numberOfRetries = pollingFrequencyWithinRefreshWindow + 1;
        return new TopologyServiceMultiRetryStrategy(refreshPeriodMillis / (long)pollingFrequencyWithinRefreshWindow, numberOfRetries, logProvider);
    }

    public CoreTopologyService topologyService() {
        return this.topologyService;
    }

    public Supplier<Optional<ClusterId>> clusterIdentity() {
        return this.clusterBinder;
    }

    public ClusterBinder clusterBinder() {
        return this.clusterBinder;
    }
}

