/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.causalclustering.catchup.storecopy.LocalDatabase;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyMachine;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocationState;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationStateMachine;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenState;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenStateMachine;
import org.neo4j.causalclustering.core.state.machines.tx.RecoverConsensusLogIndex;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionStateMachine;
import org.neo4j.causalclustering.core.state.snapshot.CoreSnapshot;
import org.neo4j.causalclustering.core.state.snapshot.CoreStateType;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;

public class CoreStateMachines {
    private final ReplicatedTransactionStateMachine replicatedTxStateMachine;
    private final ReplicatedTokenStateMachine labelTokenStateMachine;
    private final ReplicatedTokenStateMachine relationshipTypeTokenStateMachine;
    private final ReplicatedTokenStateMachine propertyKeyTokenStateMachine;
    private final ReplicatedLockTokenStateMachine replicatedLockTokenStateMachine;
    private final ReplicatedIdAllocationStateMachine idAllocationStateMachine;
    private final DummyMachine benchmarkMachine;
    private final LocalDatabase localDatabase;
    private final RecoverConsensusLogIndex consensusLogIndexRecovery;
    private final CommandDispatcher dispatcher = new StateMachineCommandDispatcher();
    private volatile boolean runningBatch;

    CoreStateMachines(ReplicatedTransactionStateMachine replicatedTxStateMachine, ReplicatedTokenStateMachine labelTokenStateMachine, ReplicatedTokenStateMachine relationshipTypeTokenStateMachine, ReplicatedTokenStateMachine propertyKeyTokenStateMachine, ReplicatedLockTokenStateMachine replicatedLockTokenStateMachine, ReplicatedIdAllocationStateMachine idAllocationStateMachine, DummyMachine benchmarkMachine, LocalDatabase localDatabase, RecoverConsensusLogIndex consensusLogIndexRecovery) {
        this.replicatedTxStateMachine = replicatedTxStateMachine;
        this.labelTokenStateMachine = labelTokenStateMachine;
        this.relationshipTypeTokenStateMachine = relationshipTypeTokenStateMachine;
        this.propertyKeyTokenStateMachine = propertyKeyTokenStateMachine;
        this.replicatedLockTokenStateMachine = replicatedLockTokenStateMachine;
        this.idAllocationStateMachine = idAllocationStateMachine;
        this.benchmarkMachine = benchmarkMachine;
        this.localDatabase = localDatabase;
        this.consensusLogIndexRecovery = consensusLogIndexRecovery;
    }

    public CommandDispatcher commandDispatcher() {
        this.localDatabase.assertHealthy(IllegalStateException.class);
        assert (!this.runningBatch);
        this.runningBatch = true;
        return this.dispatcher;
    }

    public long getLastAppliedIndex() {
        long lastAppliedLockTokenIndex = this.replicatedLockTokenStateMachine.lastAppliedIndex();
        long lastAppliedIdAllocationIndex = this.idAllocationStateMachine.lastAppliedIndex();
        return Math.max(lastAppliedLockTokenIndex, lastAppliedIdAllocationIndex);
    }

    public void flush() throws IOException {
        assert (!this.runningBatch);
        this.replicatedTxStateMachine.flush();
        this.labelTokenStateMachine.flush();
        this.relationshipTypeTokenStateMachine.flush();
        this.propertyKeyTokenStateMachine.flush();
        this.replicatedLockTokenStateMachine.flush();
        this.idAllocationStateMachine.flush();
    }

    public void addSnapshots(CoreSnapshot coreSnapshot) {
        assert (!this.runningBatch);
        coreSnapshot.add(CoreStateType.ID_ALLOCATION, this.idAllocationStateMachine.snapshot());
        coreSnapshot.add(CoreStateType.LOCK_TOKEN, this.replicatedLockTokenStateMachine.snapshot());
    }

    public void installSnapshots(CoreSnapshot coreSnapshot) {
        assert (!this.runningBatch);
        this.idAllocationStateMachine.installSnapshot((IdAllocationState)coreSnapshot.get(CoreStateType.ID_ALLOCATION));
        this.replicatedLockTokenStateMachine.installSnapshot((ReplicatedLockTokenState)coreSnapshot.get(CoreStateType.LOCK_TOKEN));
    }

    public void installCommitProcess(TransactionCommitProcess localCommit) {
        assert (!this.runningBatch);
        long lastAppliedIndex = this.consensusLogIndexRecovery.findLastAppliedIndex();
        this.replicatedTxStateMachine.installCommitProcess(localCommit, lastAppliedIndex);
        this.labelTokenStateMachine.installCommitProcess(localCommit, lastAppliedIndex);
        this.relationshipTypeTokenStateMachine.installCommitProcess(localCommit, lastAppliedIndex);
        this.propertyKeyTokenStateMachine.installCommitProcess(localCommit, lastAppliedIndex);
    }

    private class StateMachineCommandDispatcher
    implements CommandDispatcher {
        private StateMachineCommandDispatcher() {
        }

        @Override
        public void dispatch(ReplicatedTransaction transaction, long commandIndex, Consumer<Result> callback) {
            CoreStateMachines.this.replicatedTxStateMachine.applyCommand(transaction, commandIndex, callback);
        }

        @Override
        public void dispatch(ReplicatedIdAllocationRequest idRequest, long commandIndex, Consumer<Result> callback) {
            CoreStateMachines.this.replicatedTxStateMachine.ensuredApplied();
            CoreStateMachines.this.idAllocationStateMachine.applyCommand(idRequest, commandIndex, callback);
        }

        @Override
        public void dispatch(ReplicatedTokenRequest tokenRequest, long commandIndex, Consumer<Result> callback) {
            CoreStateMachines.this.replicatedTxStateMachine.ensuredApplied();
            switch (tokenRequest.type()) {
                case PROPERTY: {
                    CoreStateMachines.this.propertyKeyTokenStateMachine.applyCommand(tokenRequest, commandIndex, callback);
                    break;
                }
                case RELATIONSHIP: {
                    CoreStateMachines.this.relationshipTypeTokenStateMachine.applyCommand(tokenRequest, commandIndex, callback);
                    break;
                }
                case LABEL: {
                    CoreStateMachines.this.labelTokenStateMachine.applyCommand(tokenRequest, commandIndex, callback);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        @Override
        public void dispatch(ReplicatedLockTokenRequest lockRequest, long commandIndex, Consumer<Result> callback) {
            CoreStateMachines.this.replicatedTxStateMachine.ensuredApplied();
            CoreStateMachines.this.replicatedLockTokenStateMachine.applyCommand(lockRequest, commandIndex, callback);
        }

        @Override
        public void dispatch(DummyRequest dummyRequest, long commandIndex, Consumer<Result> callback) {
            CoreStateMachines.this.benchmarkMachine.applyCommand(dummyRequest, commandIndex, callback);
        }

        @Override
        public void close() {
            CoreStateMachines.this.runningBatch = false;
            CoreStateMachines.this.replicatedTxStateMachine.ensuredApplied();
        }
    }
}

