/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.IOException;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.CommandDispatcher;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.tx.CoreReplicatedContent;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.marshalling.ReplicatedContentHandler;
import org.neo4j.kernel.impl.store.id.IdType;

public class ReplicatedIdAllocationRequest
implements CoreReplicatedContent {
    private final MemberId owner;
    private final IdType idType;
    private final long idRangeStart;
    private final int idRangeLength;

    public ReplicatedIdAllocationRequest(MemberId owner, IdType idType, long idRangeStart, int idRangeLength) {
        this.owner = owner;
        this.idType = idType;
        this.idRangeStart = idRangeStart;
        this.idRangeLength = idRangeLength;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicatedIdAllocationRequest that = (ReplicatedIdAllocationRequest)o;
        if (this.idRangeStart != that.idRangeStart) {
            return false;
        }
        if (this.idRangeLength != that.idRangeLength) {
            return false;
        }
        if (!this.owner.equals(that.owner)) {
            return false;
        }
        return this.idType == that.idType;
    }

    public int hashCode() {
        int result = this.owner.hashCode();
        result = 31 * result + this.idType.hashCode();
        result = 31 * result + (int)(this.idRangeStart ^ this.idRangeStart >>> 32);
        result = 31 * result + this.idRangeLength;
        return result;
    }

    public MemberId owner() {
        return this.owner;
    }

    public IdType idType() {
        return this.idType;
    }

    long idRangeStart() {
        return this.idRangeStart;
    }

    int idRangeLength() {
        return this.idRangeLength;
    }

    public String toString() {
        return String.format("ReplicatedIdAllocationRequest{owner=%s, idType=%s, idRangeStart=%d, idRangeLength=%d}", this.owner, this.idType, this.idRangeStart, this.idRangeLength);
    }

    @Override
    public void dispatch(CommandDispatcher commandDispatcher, long commandIndex, Consumer<Result> callback) {
        commandDispatcher.dispatch(this, commandIndex, callback);
    }

    @Override
    public void handle(ReplicatedContentHandler contentHandler) throws IOException {
        contentHandler.handle(this);
    }
}

