/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.LongSupplier;
import org.neo4j.causalclustering.core.state.machines.id.IdAllocation;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdContainer;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdRange;
import org.neo4j.kernel.impl.store.id.IdRangeIterator;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

class ReplicatedIdGenerator
implements IdGenerator {
    private final IdType idType;
    private final Log log;
    private final ReplicatedIdRangeAcquirer acquirer;
    private volatile long highId;
    private volatile IdRangeIterator idQueue = IdRangeIterator.EMPTY_ID_RANGE_ITERATOR;
    private final IdContainer idContainer;
    private final ReentrantLock idContainerLock = new ReentrantLock();

    ReplicatedIdGenerator(FileSystemAbstraction fs, File file, IdType idType, LongSupplier highId, ReplicatedIdRangeAcquirer acquirer, LogProvider logProvider, int grabSize, boolean aggressiveReuse) {
        this.idType = idType;
        this.highId = highId.getAsLong();
        this.acquirer = acquirer;
        this.log = logProvider.getLog(this.getClass());
        this.idContainer = new IdContainer(fs, file, grabSize, aggressiveReuse);
        this.idContainer.init();
    }

    public void close() {
        this.idContainerLock.lock();
        try {
            this.idContainer.close(this.highId);
        }
        finally {
            this.idContainerLock.unlock();
        }
    }

    public void freeId(long id) {
        this.idContainerLock.lock();
        try {
            this.idContainer.freeId(id);
        }
        finally {
            this.idContainerLock.unlock();
        }
    }

    public long getHighId() {
        return this.highId;
    }

    public void setHighId(long id) {
        this.highId = Math.max(this.highId, id);
    }

    public long getHighestPossibleIdInUse() {
        return this.highId - 1L;
    }

    public long getNumberOfIdsInUse() {
        return this.highId - this.getDefragCount();
    }

    public synchronized long nextId() {
        long id = this.getReusableId();
        if (id != -1L) {
            return id;
        }
        long nextId = this.idQueue.nextId();
        if (nextId == -1L) {
            this.acquireNextIdBatch();
            nextId = this.idQueue.nextId();
        }
        this.highId = Math.max(this.highId, nextId + 1L);
        return nextId;
    }

    private void acquireNextIdBatch() {
        IdAllocation allocation = this.acquirer.acquireIds(this.idType);
        assert (allocation.getIdRange().getRangeLength() > 0);
        this.log.debug("Received id allocation " + allocation + " for " + this.idType);
        this.storeLocally(allocation);
    }

    public synchronized IdRange nextIdBatch(int size) {
        IdRange idBatch = this.getReusableIdBatch(size);
        if (idBatch.totalSize() > 0) {
            return idBatch;
        }
        IdRange range = this.idQueue.nextIdBatch(size);
        if (range.totalSize() == 0) {
            this.acquireNextIdBatch();
            range = this.idQueue.nextIdBatch(size);
            this.setHighId(range.getHighId());
        }
        return range;
    }

    public long getDefragCount() {
        this.idContainerLock.lock();
        try {
            long l = this.idContainer.getFreeIdCount();
            return l;
        }
        finally {
            this.idContainerLock.unlock();
        }
    }

    public void delete() {
        this.idContainerLock.lock();
        try {
            this.idContainer.delete();
        }
        finally {
            this.idContainerLock.unlock();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.idQueue + "]";
    }

    static void createGenerator(FileSystemAbstraction fs, File fileName, long highId, boolean throwIfFileExists) {
        IdContainer.createEmptyIdFile((FileSystemAbstraction)fs, (File)fileName, (long)highId, (boolean)throwIfFileExists);
    }

    private long getReusableId() {
        this.idContainerLock.lock();
        try {
            long l = this.idContainer.getReusableId();
            return l;
        }
        finally {
            this.idContainerLock.unlock();
        }
    }

    private IdRange getReusableIdBatch(int maxSize) {
        this.idContainerLock.lock();
        try {
            IdRange idRange = this.idContainer.getReusableIdBatch(maxSize);
            return idRange;
        }
        finally {
            this.idContainerLock.unlock();
        }
    }

    private void storeLocally(IdAllocation allocation) {
        this.setHighId(allocation.getHighestIdInUse() + 1L);
        this.idQueue = this.respectingHighId(allocation.getIdRange()).iterator();
    }

    private IdRange respectingHighId(IdRange idRange) {
        int adjustment = 0;
        long originalRangeStart = idRange.getRangeStart();
        if (this.highId > originalRangeStart) {
            adjustment = (int)(this.highId - originalRangeStart);
        }
        long rangeStart = Math.max(this.highId, originalRangeStart);
        int rangeLength = idRange.getRangeLength() - adjustment;
        if (rangeLength <= 0) {
            throw new IllegalStateException("IdAllocation state is probably corrupted or out of sync with the cluster. Local highId is " + this.highId + " and allocation range is " + idRange);
        }
        return new IdRange(idRange.getDefragIds(), rangeStart, rangeLength);
    }
}

