/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.id;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.function.LongSupplier;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdGenerator;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdRangeAcquirer;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.store.id.IdGenerator;
import org.neo4j.kernel.impl.store.id.IdGeneratorFactory;
import org.neo4j.kernel.impl.store.id.IdType;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfiguration;
import org.neo4j.kernel.impl.store.id.configuration.IdTypeConfigurationProvider;
import org.neo4j.logging.LogProvider;

public class ReplicatedIdGeneratorFactory
implements IdGeneratorFactory {
    private final Map<IdType, ReplicatedIdGenerator> generators = new HashMap<IdType, ReplicatedIdGenerator>();
    private final FileSystemAbstraction fs;
    private final ReplicatedIdRangeAcquirer idRangeAcquirer;
    private final LogProvider logProvider;
    private IdTypeConfigurationProvider idTypeConfigurationProvider;

    public ReplicatedIdGeneratorFactory(FileSystemAbstraction fs, ReplicatedIdRangeAcquirer idRangeAcquirer, LogProvider logProvider, IdTypeConfigurationProvider idTypeConfigurationProvider) {
        this.fs = fs;
        this.idRangeAcquirer = idRangeAcquirer;
        this.logProvider = logProvider;
        this.idTypeConfigurationProvider = idTypeConfigurationProvider;
    }

    public IdGenerator open(File file, IdType idType, LongSupplier highId, long maxId) {
        IdTypeConfiguration idTypeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
        return this.openGenerator(file, idTypeConfiguration.getGrabSize(), idType, highId, maxId, idTypeConfiguration.allowAggressiveReuse());
    }

    public IdGenerator open(File fileName, int grabSize, IdType idType, LongSupplier highId, long maxId) {
        IdTypeConfiguration idTypeConfiguration = this.idTypeConfigurationProvider.getIdTypeConfiguration(idType);
        return this.openGenerator(fileName, grabSize, idType, highId, maxId, idTypeConfiguration.allowAggressiveReuse());
    }

    private IdGenerator openGenerator(File file, int grabSize, IdType idType, LongSupplier highId, long maxId, boolean aggressiveReuse) {
        ReplicatedIdGenerator other = this.generators.get(idType);
        if (other != null) {
            other.close();
        }
        ReplicatedIdGenerator replicatedIdGenerator = new ReplicatedIdGenerator(this.fs, file, idType, highId, this.idRangeAcquirer, this.logProvider, grabSize, aggressiveReuse);
        this.generators.put(idType, replicatedIdGenerator);
        return replicatedIdGenerator;
    }

    public IdGenerator get(IdType idType) {
        return this.generators.get(idType);
    }

    public void create(File fileName, long highId, boolean throwIfFileExists) {
        ReplicatedIdGenerator.createGenerator(this.fs, fileName, highId, throwIfFileExists);
    }
}

