/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.token;

import java.util.Collection;
import java.util.function.Consumer;
import org.neo4j.causalclustering.core.state.Result;
import org.neo4j.causalclustering.core.state.machines.StateMachine;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.tx.LogIndexTxHeaderEncoding;
import org.neo4j.internal.kernel.api.NamedToken;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContext;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.kernel.impl.api.TransactionCommitProcess;
import org.neo4j.kernel.impl.api.TransactionToApply;
import org.neo4j.kernel.impl.core.TokenRegistry;
import org.neo4j.kernel.impl.locking.LockGroup;
import org.neo4j.kernel.impl.store.record.TokenRecord;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.kernel.impl.transaction.command.Command;
import org.neo4j.kernel.impl.transaction.log.PhysicalTransactionRepresentation;
import org.neo4j.kernel.impl.transaction.tracing.CommitEvent;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.TransactionApplicationMode;

public class ReplicatedTokenStateMachine
implements StateMachine<ReplicatedTokenRequest> {
    private TransactionCommitProcess commitProcess;
    private final TokenRegistry tokenRegistry;
    private final VersionContext versionContext;
    private final Log log;
    private long lastCommittedIndex = -1L;

    public ReplicatedTokenStateMachine(TokenRegistry tokenRegistry, LogProvider logProvider, VersionContextSupplier versionContextSupplier) {
        this.tokenRegistry = tokenRegistry;
        this.versionContext = versionContextSupplier.getVersionContext();
        this.log = logProvider.getLog(this.getClass());
    }

    public synchronized void installCommitProcess(TransactionCommitProcess commitProcess, long lastCommittedIndex) {
        this.commitProcess = commitProcess;
        this.lastCommittedIndex = lastCommittedIndex;
        this.log.info(String.format("(%s) Updated lastCommittedIndex to %d", this.tokenRegistry.getTokenType(), lastCommittedIndex));
    }

    @Override
    public synchronized void applyCommand(ReplicatedTokenRequest tokenRequest, long commandIndex, Consumer<Result> callback) {
        if (commandIndex <= this.lastCommittedIndex) {
            this.log.warn(String.format("Ignored %s because already committed (%d <= %d).", tokenRequest, commandIndex, this.lastCommittedIndex));
            return;
        }
        Collection<StorageCommand> commands = ReplicatedTokenRequestSerializer.extractCommands(tokenRequest.commandBytes());
        int newTokenId = this.extractTokenId(commands);
        Integer existingTokenId = this.tokenRegistry.getId(tokenRequest.tokenName());
        if (existingTokenId == null) {
            this.log.info(String.format("Applying %s with newTokenId=%d", tokenRequest, newTokenId));
            this.applyToStore(commands, commandIndex);
            this.tokenRegistry.put(new NamedToken(tokenRequest.tokenName(), newTokenId));
            callback.accept(Result.of(newTokenId));
        } else {
            this.log.warn(String.format("Ignored %s (newTokenId=%d) since it already exists with existingTokenId=%d", tokenRequest, newTokenId, existingTokenId));
            callback.accept(Result.of(existingTokenId));
        }
    }

    private void applyToStore(Collection<StorageCommand> commands, long logIndex) {
        PhysicalTransactionRepresentation representation = new PhysicalTransactionRepresentation(commands);
        representation.setHeader(LogIndexTxHeaderEncoding.encodeLogIndexAsTxHeader(logIndex), 0, 0, 0L, 0L, 0L, 0);
        try (LockGroup ignored = new LockGroup();){
            this.commitProcess.commit(new TransactionToApply((TransactionRepresentation)representation, this.versionContext), CommitEvent.NULL, TransactionApplicationMode.EXTERNAL);
        }
        catch (TransactionFailureException e) {
            throw new RuntimeException(e);
        }
    }

    private int extractTokenId(Collection<StorageCommand> commands) {
        for (StorageCommand command : commands) {
            if (!(command instanceof Command.TokenCommand)) continue;
            return ((TokenRecord)((Command.TokenCommand)command).getAfter()).getIntId();
        }
        throw new IllegalStateException("Commands did not contain token command");
    }

    @Override
    public synchronized void flush() {
    }

    @Override
    public long lastAppliedIndex() {
        if (this.commitProcess == null) {
            throw new IllegalStateException("Value has not been installed");
        }
        return this.lastCommittedIndex;
    }
}

