/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import io.netty.buffer.ByteBuf;
import io.netty.handler.stream.ChunkedInput;
import java.io.IOException;
import java.util.Arrays;
import java.util.OptionalLong;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionSerializer;
import org.neo4j.causalclustering.core.state.machines.tx.TransactionRepresentationExtractor;
import org.neo4j.causalclustering.messaging.marshalling.ReplicatedContentHandler;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;
import org.neo4j.storageengine.api.WritableChannel;

public class ByteArrayReplicatedTransaction
implements ReplicatedTransaction {
    private final byte[] txBytes;

    @Override
    public OptionalLong size() {
        return OptionalLong.of(this.txBytes.length);
    }

    @Override
    public void handle(ReplicatedContentHandler contentHandler) throws IOException {
        contentHandler.handle(this);
    }

    ByteArrayReplicatedTransaction(byte[] txBytes) {
        this.txBytes = txBytes;
    }

    byte[] getTxBytes() {
        return this.txBytes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteArrayReplicatedTransaction that = (ByteArrayReplicatedTransaction)o;
        return Arrays.equals(this.txBytes, that.txBytes);
    }

    public int hashCode() {
        return Arrays.hashCode(this.txBytes);
    }

    @Override
    public ChunkedInput<ByteBuf> encode() {
        return ReplicatedTransactionSerializer.encode(this);
    }

    @Override
    public void marshal(WritableChannel channel) throws IOException {
        ReplicatedTransactionSerializer.marshal(channel, this);
    }

    @Override
    public TransactionRepresentation extract(TransactionRepresentationExtractor extractor) {
        return extractor.extract(this);
    }

    public String toString() {
        return "ByteArrayReplicatedTransaction{txBytes.length=" + this.txBytes.length + '}';
    }
}

