/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.core.state.machines.tx;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.ReferenceCountUtil;
import java.util.LinkedList;
import java.util.Queue;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionFactory;
import org.neo4j.causalclustering.helper.ErrorHandler;
import org.neo4j.causalclustering.messaging.ChunkingNetworkChannel;
import org.neo4j.kernel.impl.transaction.TransactionRepresentation;

class ChunkedTransaction
implements ChunkedInput<ByteBuf> {
    private static final int CHUNK_SIZE = 32768;
    private final ReplicatedTransactionFactory.TransactionRepresentationWriter txWriter;
    private ChunkingNetworkChannel channel;
    private Queue<ByteBuf> chunks = new LinkedList<ByteBuf>();

    ChunkedTransaction(TransactionRepresentation tx) {
        this.txWriter = ReplicatedTransactionFactory.transactionalRepresentationWriter(tx);
    }

    public boolean isEndOfInput() {
        return this.channel != null && this.channel.closed() && this.chunks.isEmpty();
    }

    public void close() {
        try (ErrorHandler errorHandler = new ErrorHandler("Closing ChunkedTransaction");){
            if (this.channel != null) {
                errorHandler.execute(() -> this.channel.close());
            }
            this.chunks.forEach(byteBuf -> errorHandler.execute(() -> ReferenceCountUtil.release((Object)byteBuf)));
        }
    }

    public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
        return this.readChunk(ctx.alloc());
    }

    public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        if (this.channel == null) {
            this.channel = new ChunkingNetworkChannel(allocator, 32768, this.chunks);
        }
        while (this.txWriter.canWrite() && this.chunks.isEmpty()) {
            this.txWriter.write(this.channel);
        }
        if (this.chunks.isEmpty()) {
            this.channel.close();
        }
        return this.chunks.poll();
    }

    public long length() {
        return -1L;
    }

    public long progress() {
        return 0L;
    }
}

