/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Objects;
import org.neo4j.causalclustering.core.consensus.LeaderInfo;
import org.neo4j.causalclustering.discovery.CoreTopologyListenerService;
import org.neo4j.causalclustering.discovery.CoreTopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.SafeLifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public abstract class AbstractCoreTopologyService
extends SafeLifecycle
implements CoreTopologyService {
    protected final CoreTopologyListenerService listenerService = new CoreTopologyListenerService();
    protected final Config config;
    protected final MemberId myself;
    protected final Log log;
    protected final Log userLog;

    protected AbstractCoreTopologyService(Config config, MemberId myself, LogProvider logProvider, LogProvider userLogProvider) {
        this.config = config;
        this.myself = myself;
        this.log = logProvider.getLog(this.getClass());
        this.userLog = userLogProvider.getLog(this.getClass());
    }

    @Override
    public final void addLocalCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.addCoreTopologyListener(listener);
        listener.onCoreTopologyChange(this.localCoreServers());
    }

    @Override
    public final void removeLocalCoreTopologyListener(CoreTopologyService.Listener listener) {
        this.listenerService.removeCoreTopologyListener(listener);
    }

    @Override
    public final void setLeader(LeaderInfo newLeader, String dbName) {
        LeaderInfo currentLeaderInfo = this.getLeader();
        if (currentLeaderInfo.term() < newLeader.term() && this.localDBName().equals(dbName)) {
            this.log.info("Leader %s updating leader info for database %s and term %s", new Object[]{this.myself, dbName, newLeader.term()});
            this.setLeader0(newLeader);
        }
    }

    protected abstract void setLeader0(LeaderInfo var1);

    @Override
    public final void handleStepDown(long term, String dbName) {
        boolean wasLeaderForDbAndTerm;
        LeaderInfo localLeaderInfo = this.getLeader();
        boolean bl = wasLeaderForDbAndTerm = Objects.equals(this.myself, localLeaderInfo.memberId()) && this.localDBName().equals(dbName) && term == localLeaderInfo.term();
        if (wasLeaderForDbAndTerm) {
            this.log.info("Step down event detected. This topology member, with MemberId %s, was leader in term %s, now moving to follower.", new Object[]{this.myself, localLeaderInfo.term()});
            this.handleStepDown0(localLeaderInfo.stepDown());
        }
    }

    protected abstract void handleStepDown0(LeaderInfo var1);

    @Override
    public MemberId myself() {
        return this.myself;
    }
}

