/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.net.InetAddress;
import java.util.Collection;
import java.util.HashSet;
import org.neo4j.causalclustering.discovery.DomainNameResolver;
import org.neo4j.causalclustering.discovery.InitialDiscoveryMembersResolver;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.causalclustering.discovery.RetryingHostnameResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class DnsHostnameResolver
extends RetryingHostnameResolver {
    private final Log userLog;
    private final Log log;
    private final DomainNameResolver domainNameResolver;

    public static RemoteMembersResolver resolver(LogService logService, DomainNameResolver domainNameResolver, Config config) {
        DnsHostnameResolver hostnameResolver = new DnsHostnameResolver(logService, domainNameResolver, config, DnsHostnameResolver.defaultRetryStrategy(config, logService.getInternalLogProvider()));
        return new InitialDiscoveryMembersResolver(hostnameResolver, config);
    }

    DnsHostnameResolver(LogService logService, DomainNameResolver domainNameResolver, Config config, MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> retryStrategy) {
        super(config, retryStrategy);
        this.log = logService.getInternalLog(this.getClass());
        this.userLog = logService.getUserLog(this.getClass());
        this.domainNameResolver = domainNameResolver;
    }

    @Override
    protected Collection<AdvertisedSocketAddress> resolveOnce(AdvertisedSocketAddress initialAddress) {
        HashSet<AdvertisedSocketAddress> addresses = new HashSet<AdvertisedSocketAddress>();
        InetAddress[] ipAddresses = this.domainNameResolver.resolveDomainName(initialAddress.getHostname());
        if (ipAddresses.length == 0) {
            this.log.error("Failed to resolve host '%s'", new Object[]{initialAddress.getHostname()});
        }
        for (InetAddress ipAddress : ipAddresses) {
            addresses.add(new AdvertisedSocketAddress(ipAddress.getHostAddress(), initialAddress.getPort()));
        }
        this.userLog.info("Resolved initial host '%s' to %s", new Object[]{initialAddress, addresses});
        return addresses;
    }
}

