/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.HazelcastClusterTopology;
import org.neo4j.causalclustering.discovery.HazelcastConnector;
import org.neo4j.causalclustering.discovery.HazelcastInstanceNotActiveException;
import org.neo4j.causalclustering.discovery.ReadReplicaTopology;
import org.neo4j.causalclustering.discovery.RobustHazelcastWrapper;
import org.neo4j.causalclustering.discovery.RoleInfo;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.discovery.TopologyServiceMultiRetryStrategy;
import org.neo4j.causalclustering.discovery.TopologyServiceRetryStrategy;
import org.neo4j.causalclustering.helper.RobustJobSchedulerWrapper;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.function.ThrowingAction;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.lifecycle.SafeLifecycle;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;

public class HazelcastClient
extends SafeLifecycle
implements TopologyService {
    private final Log log;
    private final ClientConnectorAddresses connectorAddresses;
    private final RobustHazelcastWrapper hzInstance;
    private final RobustJobSchedulerWrapper scheduler;
    private final Config config;
    private final long timeToLive;
    private final long refreshPeriod;
    private final AdvertisedSocketAddress transactionSource;
    private final MemberId myself;
    private final List<String> groups;
    private final TopologyServiceRetryStrategy topologyServiceRetryStrategy;
    private final String dbName;
    private JobHandle keepAliveJob;
    private JobHandle refreshTopologyJob;
    private volatile CoreTopology coreTopology = CoreTopology.EMPTY;
    private volatile CoreTopology localCoreTopology = CoreTopology.EMPTY;
    private volatile ReadReplicaTopology readReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile ReadReplicaTopology localReadReplicaTopology = ReadReplicaTopology.EMPTY;
    private volatile Map<MemberId, AdvertisedSocketAddress> catchupAddressMap = new HashMap<MemberId, AdvertisedSocketAddress>();
    private volatile Map<MemberId, RoleInfo> coreRoles;

    public HazelcastClient(HazelcastConnector connector, JobScheduler scheduler, LogProvider logProvider, Config config, MemberId myself) {
        this.hzInstance = new RobustHazelcastWrapper(connector);
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
        this.scheduler = new RobustJobSchedulerWrapper(scheduler, this.log);
        this.connectorAddresses = ClientConnectorAddresses.extractFromConfig(config);
        this.transactionSource = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address);
        this.timeToLive = ((Duration)config.get(CausalClusteringSettings.read_replica_time_to_live)).toMillis();
        this.refreshPeriod = ((Duration)config.get(CausalClusteringSettings.cluster_topology_refresh)).toMillis();
        this.myself = myself;
        this.groups = (List)config.get(CausalClusteringSettings.server_groups);
        this.topologyServiceRetryStrategy = HazelcastClient.resolveStrategy(this.refreshPeriod, logProvider);
        this.dbName = (String)config.get(CausalClusteringSettings.database);
        this.coreRoles = Collections.emptyMap();
    }

    private static TopologyServiceRetryStrategy resolveStrategy(long refreshPeriodMillis, LogProvider logProvider) {
        int pollingFrequencyWithinRefreshWindow = 2;
        int numberOfRetries = pollingFrequencyWithinRefreshWindow + 1;
        return new TopologyServiceMultiRetryStrategy(refreshPeriodMillis / (long)pollingFrequencyWithinRefreshWindow, numberOfRetries, logProvider);
    }

    @Override
    public Map<MemberId, RoleInfo> allCoreRoles() {
        return this.coreRoles;
    }

    @Override
    public MemberId myself() {
        return this.myself;
    }

    @Override
    public String localDBName() {
        return this.dbName;
    }

    @Override
    public CoreTopology allCoreServers() {
        return this.coreTopology;
    }

    @Override
    public CoreTopology localCoreServers() {
        return this.localCoreTopology;
    }

    @Override
    public ReadReplicaTopology allReadReplicas() {
        return this.readReplicaTopology;
    }

    @Override
    public ReadReplicaTopology localReadReplicas() {
        return this.localReadReplicaTopology;
    }

    @Override
    public Optional<AdvertisedSocketAddress> findCatchupAddress(MemberId memberId) {
        return this.topologyServiceRetryStrategy.apply(memberId, this::retrieveSocketAddress, Optional::isPresent);
    }

    private Optional<AdvertisedSocketAddress> retrieveSocketAddress(MemberId memberId) {
        return Optional.ofNullable(this.catchupAddressMap.get(memberId));
    }

    private void refreshTopology() throws HazelcastInstanceNotActiveException {
        ReadReplicaTopology newReadReplicaTopology;
        CoreTopology newCoreTopology;
        this.coreTopology = newCoreTopology = this.hzInstance.apply(hz -> HazelcastClusterTopology.getCoreTopology(hz, this.config, this.log));
        this.localCoreTopology = newCoreTopology.filterTopologyByDb(this.dbName);
        this.readReplicaTopology = newReadReplicaTopology = this.hzInstance.apply(hz -> HazelcastClusterTopology.getReadReplicaTopology(hz, this.log));
        this.localReadReplicaTopology = newReadReplicaTopology.filterTopologyByDb(this.dbName);
        this.catchupAddressMap = HazelcastClusterTopology.extractCatchupAddressesMap(this.localCoreServers(), this.localReadReplicas());
    }

    private void refreshRoles() throws HazelcastInstanceNotActiveException {
        this.coreRoles = this.hzInstance.apply(hz -> HazelcastClusterTopology.getCoreRoles(hz, this.allCoreServers().members().keySet()));
    }

    public void init0() {
    }

    public void start0() {
        this.keepAliveJob = this.scheduler.scheduleRecurring(Group.HZ_TOPOLOGY_KEEP_ALIVE, this.timeToLive / 3L, (ThrowingAction<Exception>)((ThrowingAction)this::keepReadReplicaAlive));
        this.refreshTopologyJob = this.scheduler.scheduleRecurring(Group.HZ_TOPOLOGY_REFRESH, this.refreshPeriod, (ThrowingAction<Exception>)((ThrowingAction)() -> {
            this.refreshTopology();
            this.refreshRoles();
        }));
    }

    public void stop0() {
        this.keepAliveJob.cancel(true);
        this.refreshTopologyJob.cancel(true);
        this.disconnectFromCore();
    }

    public void shutdown0() {
    }

    private void disconnectFromCore() {
        try {
            String uuid = this.hzInstance.apply(hzInstance -> hzInstance.getLocalEndpoint().getUuid());
            this.hzInstance.apply(hz -> hz.getMap("read_replicas").remove((Object)uuid));
            this.hzInstance.shutdown();
        }
        catch (Throwable e) {
            this.log.warn("Unable to shutdown hazelcast cleanly", e);
        }
    }

    private void keepReadReplicaAlive() throws HazelcastInstanceNotActiveException {
        this.hzInstance.perform(hazelcastInstance -> {
            String hzId = hazelcastInstance.getLocalEndpoint().getUuid();
            String addresses = this.connectorAddresses.toString();
            this.log.debug("Adding read replica into cluster (%s -> %s)", new Object[]{hzId, addresses});
            hazelcastInstance.getMap("read_replicas_database_names").put((Object)hzId, (Object)this.dbName, this.timeToLive, TimeUnit.MILLISECONDS);
            hazelcastInstance.getMap("read-replica-transaction-servers").put((Object)hzId, (Object)this.transactionSource.toString(), this.timeToLive, TimeUnit.MILLISECONDS);
            hazelcastInstance.getMap("read-replica-member-ids").put((Object)hzId, (Object)this.myself.getUuid().toString(), this.timeToLive, TimeUnit.MILLISECONDS);
            HazelcastClusterTopology.refreshGroups(hazelcastInstance, hzId, this.groups);
            hazelcastInstance.getMap("read_replicas").put((Object)hzId, (Object)addresses, this.timeToLive, TimeUnit.MILLISECONDS);
        });
    }
}

