/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.HostnameResolver;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.helpers.SocketAddress;
import org.neo4j.kernel.configuration.Config;

public class InitialDiscoveryMembersResolver
implements RemoteMembersResolver {
    private final HostnameResolver hostnameResolver;
    private final List<AdvertisedSocketAddress> advertisedSocketAddresses;
    public static final Comparator<AdvertisedSocketAddress> advertisedSockedAddressComparator = Comparator.comparing(SocketAddress::getHostname).thenComparingInt(SocketAddress::getPort);

    public InitialDiscoveryMembersResolver(HostnameResolver hostnameResolver, Config config) {
        this.hostnameResolver = hostnameResolver;
        this.advertisedSocketAddresses = (List)config.get(CausalClusteringSettings.initial_discovery_members);
    }

    public <C extends Collection<T>, T> C resolve(Function<AdvertisedSocketAddress, T> transform, Supplier<C> collectionFactory) {
        return (C)((Collection)this.advertisedSocketAddresses.stream().flatMap(raw -> this.hostnameResolver.resolve((AdvertisedSocketAddress)raw).stream()).sorted(advertisedSockedAddressComparator).distinct().map(transform).collect(Collectors.toCollection(collectionFactory)));
    }

    public static Comparator<AdvertisedSocketAddress> advertisedSocketAddressComparator() {
        return advertisedSockedAddressComparator;
    }

    @Override
    public boolean useOverrides() {
        return this.hostnameResolver.useOverrides();
    }
}

