/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.net.InetAddress;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.discovery.DomainNameResolver;
import org.neo4j.causalclustering.discovery.UnknownHostException;

public class MapDomainNameResolver
implements DomainNameResolver {
    private final Map<String, InetAddress[]> domainNameMapping;

    public MapDomainNameResolver(Map<String, InetAddress[]> mapping) {
        this.domainNameMapping = mapping;
    }

    @Override
    public InetAddress[] resolveDomainName(String hostname) throws UnknownHostException {
        return Optional.ofNullable(this.domainNameMapping.get(hostname)).orElse(new InetAddress[0]);
    }

    public void setHostnameAddresses(String hostname, Collection<String> addresses) {
        InetAddress[] processedAddresses = new InetAddress[addresses.size()];
        addresses.stream().map(MapDomainNameResolver::inetAddress).collect(Collectors.toList()).toArray(processedAddresses);
        this.domainNameMapping.put(hostname, processedAddresses);
    }

    private static InetAddress inetAddress(String address) {
        try {
            return InetAddress.getByName(address);
        }
        catch (java.net.UnknownHostException e) {
            throw new UnknownHostException(e);
        }
    }
}

