/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.ClientConnectorAddresses;
import org.neo4j.causalclustering.discovery.DiscoveryServerInfo;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;

public class ReadReplicaInfo
implements DiscoveryServerInfo {
    private final AdvertisedSocketAddress catchupServerAddress;
    private final ClientConnectorAddresses clientConnectorAddresses;
    private final Set<String> groups;
    private final String dbName;

    public ReadReplicaInfo(ClientConnectorAddresses clientConnectorAddresses, AdvertisedSocketAddress catchupServerAddress, String dbName) {
        this(clientConnectorAddresses, catchupServerAddress, Collections.emptySet(), dbName);
    }

    public ReadReplicaInfo(ClientConnectorAddresses clientConnectorAddresses, AdvertisedSocketAddress catchupServerAddress, Set<String> groups, String dbName) {
        this.clientConnectorAddresses = clientConnectorAddresses;
        this.catchupServerAddress = catchupServerAddress;
        this.groups = groups;
        this.dbName = dbName;
    }

    @Override
    public String getDatabaseName() {
        return this.dbName;
    }

    @Override
    public ClientConnectorAddresses connectors() {
        return this.clientConnectorAddresses;
    }

    @Override
    public AdvertisedSocketAddress getCatchupServer() {
        return this.catchupServerAddress;
    }

    @Override
    public Set<String> groups() {
        return this.groups;
    }

    public String toString() {
        return "ReadReplicaInfo{catchupServerAddress=" + this.catchupServerAddress + ", clientConnectorAddresses=" + this.clientConnectorAddresses + ", groups=" + this.groups + '}';
    }

    public static ReadReplicaInfo from(Config config) {
        AdvertisedSocketAddress transactionSource = (AdvertisedSocketAddress)config.get(CausalClusteringSettings.transaction_advertised_address);
        ClientConnectorAddresses clientConnectorAddresses = ClientConnectorAddresses.extractFromConfig(config);
        String dbName = (String)config.get(CausalClusteringSettings.database);
        List groupList = (List)config.get(CausalClusteringSettings.server_groups);
        HashSet<String> groups = new HashSet<String>(groupList);
        return new ReadReplicaInfo(clientConnectorAddresses, transactionSource, groups, dbName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadReplicaInfo that = (ReadReplicaInfo)o;
        return Objects.equals(this.catchupServerAddress, that.catchupServerAddress) && Objects.equals(this.clientConnectorAddresses, that.clientConnectorAddresses) && Objects.equals(this.groups, that.groups) && Objects.equals(this.dbName, that.dbName);
    }

    public int hashCode() {
        return Objects.hash(this.catchupServerAddress, this.clientConnectorAddresses, this.groups, this.dbName);
    }
}

