/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.neo4j.causalclustering.discovery.ReadReplicaInfo;
import org.neo4j.causalclustering.discovery.Topology;
import org.neo4j.causalclustering.identity.MemberId;

public class ReadReplicaTopology
implements Topology<ReadReplicaInfo> {
    public static final ReadReplicaTopology EMPTY = new ReadReplicaTopology(Collections.emptyMap());
    private final Map<MemberId, ReadReplicaInfo> readReplicaMembers;

    public ReadReplicaTopology(Map<MemberId, ReadReplicaInfo> readReplicaMembers) {
        this.readReplicaMembers = readReplicaMembers;
    }

    public Collection<ReadReplicaInfo> allMemberInfo() {
        return this.readReplicaMembers.values();
    }

    @Override
    public Map<MemberId, ReadReplicaInfo> members() {
        return this.readReplicaMembers;
    }

    public String toString() {
        return String.format("{readReplicas=%s}", this.readReplicaMembers);
    }

    public ReadReplicaTopology filterTopologyByDb(String dbName) {
        Map<MemberId, ReadReplicaInfo> filteredMembers = this.filterHostsByDb(this.members(), dbName);
        return new ReadReplicaTopology(filteredMembers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReadReplicaTopology that = (ReadReplicaTopology)o;
        return Objects.equals(this.readReplicaMembers, that.readReplicaMembers);
    }

    public int hashCode() {
        return Objects.hash(this.readReplicaMembers);
    }
}

