/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.discovery;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import org.neo4j.causalclustering.discovery.InitialDiscoveryMembersResolver;
import org.neo4j.causalclustering.discovery.MultiRetryStrategy;
import org.neo4j.causalclustering.discovery.RemoteMembersResolver;
import org.neo4j.causalclustering.discovery.RetryingHostnameResolver;
import org.neo4j.causalclustering.discovery.SrvRecordResolver;
import org.neo4j.helpers.AdvertisedSocketAddress;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class SrvHostnameResolver
extends RetryingHostnameResolver {
    private final Log userLog;
    private final Log log;
    private final SrvRecordResolver srvRecordResolver;

    public static RemoteMembersResolver resolver(LogService logService, SrvRecordResolver srvHostnameResolver, Config config) {
        SrvHostnameResolver hostnameResolver = new SrvHostnameResolver(logService, srvHostnameResolver, config, SrvHostnameResolver.defaultRetryStrategy(config, logService.getInternalLogProvider()));
        return new InitialDiscoveryMembersResolver(hostnameResolver, config);
    }

    SrvHostnameResolver(LogService logService, SrvRecordResolver srvRecordResolver, Config config, MultiRetryStrategy<AdvertisedSocketAddress, Collection<AdvertisedSocketAddress>> retryStrategy) {
        super(config, retryStrategy);
        this.log = logService.getInternalLog(this.getClass());
        this.userLog = logService.getUserLog(this.getClass());
        this.srvRecordResolver = srvRecordResolver;
    }

    @Override
    public Collection<AdvertisedSocketAddress> resolveOnce(AdvertisedSocketAddress initialAddress) {
        try {
            Set<AdvertisedSocketAddress> addresses = this.srvRecordResolver.resolveSrvRecord(initialAddress.getHostname()).map(srvRecord -> new AdvertisedSocketAddress(srvRecord.host, srvRecord.port)).collect(Collectors.toSet());
            this.userLog.info("Resolved initial host '%s' to %s", new Object[]{initialAddress, addresses});
            if (addresses.isEmpty()) {
                this.log.error("Failed to resolve srv records for '%s'", new Object[]{initialAddress.getHostname()});
            }
            return addresses;
        }
        catch (NamingException e) {
            this.log.error(String.format("Failed to resolve srv records for '%s'", initialAddress.getHostname()), (Throwable)e);
            return Collections.emptySet();
        }
    }
}

