/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.helper;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.neo4j.time.Clocks;

public class Limiters {
    private final ConcurrentHashMap<Object, Consumer<Runnable>> caps = new ConcurrentHashMap();
    private final Clock clock;

    public Limiters() {
        this.clock = Clocks.systemClock();
    }

    public Limiters(Clock clock) {
        this.clock = clock;
    }

    public Consumer<Runnable> rateLimiter(Object handle, Duration minInterval) {
        return this.caps.computeIfAbsent(handle, ignored -> Limiters.rateLimiter(minInterval, this.clock));
    }

    public static Consumer<Runnable> rateLimiter(Duration minInterval) {
        return Limiters.rateLimiter(minInterval, Clocks.systemClock());
    }

    public static Consumer<Runnable> rateLimiter(final Duration minInterval, final Clock clock) {
        return new Consumer<Runnable>(){
            AtomicReference<Instant> lastRunRef = new AtomicReference();

            @Override
            public void accept(Runnable operation) {
                Instant now = clock.instant();
                Instant lastRun = this.lastRunRef.get();
                if (lastRun == null) {
                    if (this.lastRunRef.compareAndSet(null, now)) {
                        operation.run();
                    }
                    return;
                }
                if (lastRun.plus(minInterval).isAfter(now)) {
                    return;
                }
                if (this.lastRunRef.compareAndSet(lastRun, now)) {
                    operation.run();
                }
            }
        };
    }
}

