/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.identity;

import java.io.IOException;
import java.util.Objects;
import java.util.UUID;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class ClusterId {
    private final UUID uuid;

    public ClusterId(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterId clusterId = (ClusterId)o;
        return Objects.equals(this.uuid, clusterId.uuid);
    }

    public int hashCode() {
        return Objects.hash(this.uuid);
    }

    public UUID uuid() {
        return this.uuid;
    }

    public String toString() {
        return "ClusterId{uuid=" + this.uuid + '}';
    }

    public static class Marshal
    extends SafeChannelMarshal<ClusterId> {
        public static final Marshal INSTANCE = new Marshal();
        private static final UUID NIL = new UUID(0L, 0L);

        @Override
        public void marshal(ClusterId clusterId, WritableChannel channel) throws IOException {
            UUID uuid = clusterId == null ? NIL : clusterId.uuid;
            channel.putLong(uuid.getMostSignificantBits());
            channel.putLong(uuid.getLeastSignificantBits());
        }

        @Override
        public ClusterId unmarshal0(ReadableChannel channel) throws IOException {
            long leastSigBits;
            long mostSigBits = channel.getLong();
            UUID uuid = new UUID(mostSigBits, leastSigBits = channel.getLong());
            return uuid.equals(NIL) ? null : new ClusterId(uuid);
        }
    }
}

