/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.address;

import java.time.Clock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.CappedLogger;

public class UnknownAddressMonitor {
    private final Log log;
    private final Clock clock;
    private final long timeLimitMs;
    private Map<MemberId, CappedLogger> loggers = new ConcurrentHashMap<MemberId, CappedLogger>();

    public UnknownAddressMonitor(Log log, Clock clock, long timeLimitMs) {
        this.log = log;
        this.clock = clock;
        this.timeLimitMs = timeLimitMs;
    }

    public void logAttemptToSendToMemberWithNoKnownAddress(MemberId to) {
        CappedLogger cappedLogger = this.loggers.get(to);
        if (cappedLogger == null) {
            cappedLogger = new CappedLogger(this.log);
            cappedLogger.setTimeLimit(this.timeLimitMs, TimeUnit.MILLISECONDS, this.clock);
            this.loggers.put(to, cappedLogger);
        }
        cappedLogger.info(String.format("No address found for %s, probably because the member has been shut down.", to));
    }
}

