/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import org.neo4j.causalclustering.core.consensus.NewLeaderBarrier;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSet;
import org.neo4j.causalclustering.core.consensus.membership.MemberIdSetSerializer;
import org.neo4j.causalclustering.core.replication.DistributedOperation;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.core.state.machines.dummy.DummyRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequest;
import org.neo4j.causalclustering.core.state.machines.id.ReplicatedIdAllocationRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenRequest;
import org.neo4j.causalclustering.core.state.machines.locks.ReplicatedLockTokenSerializer;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequest;
import org.neo4j.causalclustering.core.state.machines.token.ReplicatedTokenRequestSerializer;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransaction;
import org.neo4j.causalclustering.core.state.machines.tx.ReplicatedTransactionSerializer;
import org.neo4j.causalclustering.core.state.storage.SafeChannelMarshal;
import org.neo4j.causalclustering.messaging.EndOfStreamException;
import org.neo4j.causalclustering.messaging.NetworkReadableClosableChannelNetty4;
import org.neo4j.causalclustering.messaging.marshalling.ChunkedReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.Codec;
import org.neo4j.causalclustering.messaging.marshalling.ContentBuilder;
import org.neo4j.causalclustering.messaging.marshalling.MaxTotalSize;
import org.neo4j.causalclustering.messaging.marshalling.ReplicatedContentHandler;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.storageengine.api.ReadableChannel;
import org.neo4j.storageengine.api.WritableChannel;

public class CoreReplicatedContentMarshal {
    private static final byte TX_CONTENT_TYPE = 0;
    private static final byte RAFT_MEMBER_SET_TYPE = 1;
    private static final byte ID_RANGE_REQUEST_TYPE = 2;
    private static final byte TOKEN_REQUEST_TYPE = 4;
    private static final byte NEW_LEADER_BARRIER_TYPE = 5;
    private static final byte LOCK_TOKEN_REQUEST = 6;
    private static final byte DISTRIBUTED_OPERATION = 7;
    private static final byte DUMMY_REQUEST = 8;

    public static Codec<ReplicatedContent> codec() {
        return new ReplicatedContentCodec(new CoreReplicatedContentMarshal());
    }

    public static SafeChannelMarshal<ReplicatedContent> marshaller() {
        return new ReplicatedContentMarshaller(new CoreReplicatedContentMarshal());
    }

    private CoreReplicatedContentMarshal() {
    }

    private ContentBuilder<ReplicatedContent> unmarshal(byte contentType, ByteBuf buffer) throws IOException, EndOfStreamException {
        switch (contentType) {
            case 0: {
                return ContentBuilder.finished(ReplicatedTransactionSerializer.decode(buffer));
            }
            case 8: {
                return ContentBuilder.finished(DummyRequest.decode(buffer));
            }
        }
        return this.unmarshal(contentType, (ReadableChannel)new NetworkReadableClosableChannelNetty4(buffer));
    }

    private ContentBuilder<ReplicatedContent> unmarshal(byte contentType, ReadableChannel channel) throws IOException, EndOfStreamException {
        switch (contentType) {
            case 0: {
                return ContentBuilder.finished(ReplicatedTransactionSerializer.unmarshal(channel));
            }
            case 1: {
                return ContentBuilder.finished(MemberIdSetSerializer.unmarshal(channel));
            }
            case 2: {
                return ContentBuilder.finished(ReplicatedIdAllocationRequestSerializer.unmarshal(channel));
            }
            case 4: {
                return ContentBuilder.finished(ReplicatedTokenRequestSerializer.unmarshal(channel));
            }
            case 5: {
                return ContentBuilder.finished(new NewLeaderBarrier());
            }
            case 6: {
                return ContentBuilder.finished(ReplicatedLockTokenSerializer.unmarshal(channel));
            }
            case 7: {
                return DistributedOperation.deserialize(channel);
            }
            case 8: {
                return ContentBuilder.finished(DummyRequest.Marshal.INSTANCE.unmarshal(channel));
            }
        }
        throw new IllegalStateException("Not a recognized content type: " + contentType);
    }

    private static class MarshallingHandlerReplicated
    implements ReplicatedContentHandler {
        private final WritableChannel writableChannel;

        MarshallingHandlerReplicated(WritableChannel writableChannel) {
            this.writableChannel = writableChannel;
        }

        @Override
        public void handle(ReplicatedTransaction replicatedTransaction) throws IOException {
            this.writableChannel.put((byte)0);
            replicatedTransaction.marshal(this.writableChannel);
        }

        @Override
        public void handle(MemberIdSet memberIdSet) throws IOException {
            this.writableChannel.put((byte)1);
            MemberIdSetSerializer.marshal(memberIdSet, this.writableChannel);
        }

        @Override
        public void handle(ReplicatedIdAllocationRequest replicatedIdAllocationRequest) throws IOException {
            this.writableChannel.put((byte)2);
            ReplicatedIdAllocationRequestSerializer.marshal(replicatedIdAllocationRequest, this.writableChannel);
        }

        @Override
        public void handle(ReplicatedTokenRequest replicatedTokenRequest) throws IOException {
            this.writableChannel.put((byte)4);
            ReplicatedTokenRequestSerializer.marshal(replicatedTokenRequest, this.writableChannel);
        }

        @Override
        public void handle(NewLeaderBarrier newLeaderBarrier) throws IOException {
            this.writableChannel.put((byte)5);
        }

        @Override
        public void handle(ReplicatedLockTokenRequest replicatedLockTokenRequest) throws IOException {
            this.writableChannel.put((byte)6);
            ReplicatedLockTokenSerializer.marshal(replicatedLockTokenRequest, this.writableChannel);
        }

        @Override
        public void handle(DistributedOperation distributedOperation) throws IOException {
            this.writableChannel.put((byte)7);
            distributedOperation.marshalMetaData(this.writableChannel);
        }

        @Override
        public void handle(DummyRequest dummyRequest) throws IOException {
            this.writableChannel.put((byte)8);
            DummyRequest.Marshal.INSTANCE.marshal(dummyRequest, this.writableChannel);
        }
    }

    private static class EncodingHandlerReplicated
    implements ReplicatedContentHandler {
        private final List<Object> output;

        EncodingHandlerReplicated(List<Object> output) {
            this.output = output;
        }

        @Override
        public void handle(ReplicatedTransaction replicatedTransaction) {
            this.output.add(ChunkedReplicatedContent.chunked((byte)0, new MaxTotalSize(replicatedTransaction.encode())));
        }

        @Override
        public void handle(MemberIdSet memberIdSet) {
            this.output.add(ChunkedReplicatedContent.single((byte)1, (ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> MemberIdSetSerializer.marshal(memberIdSet, channel))));
        }

        @Override
        public void handle(ReplicatedIdAllocationRequest replicatedIdAllocationRequest) {
            this.output.add(ChunkedReplicatedContent.single((byte)2, (ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> ReplicatedIdAllocationRequestSerializer.marshal(replicatedIdAllocationRequest, channel))));
        }

        @Override
        public void handle(ReplicatedTokenRequest replicatedTokenRequest) {
            this.output.add(ChunkedReplicatedContent.single((byte)4, (ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> ReplicatedTokenRequestSerializer.marshal(replicatedTokenRequest, channel))));
        }

        @Override
        public void handle(NewLeaderBarrier newLeaderBarrier) {
            this.output.add(ChunkedReplicatedContent.single((byte)5, (ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> {})));
        }

        @Override
        public void handle(ReplicatedLockTokenRequest replicatedLockTokenRequest) {
            this.output.add(ChunkedReplicatedContent.single((byte)6, (ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)channel -> ReplicatedLockTokenSerializer.marshal(replicatedLockTokenRequest, channel))));
        }

        @Override
        public void handle(DistributedOperation distributedOperation) {
            this.output.add(ChunkedReplicatedContent.single((byte)7, (ThrowingConsumer<WritableChannel, IOException>)((ThrowingConsumer)distributedOperation::marshalMetaData)));
        }

        @Override
        public void handle(DummyRequest dummyRequest) {
            this.output.add(ChunkedReplicatedContent.chunked((byte)8, dummyRequest.encoder()));
        }
    }

    private static class ReplicatedContentMarshaller
    extends SafeChannelMarshal<ReplicatedContent> {
        private final CoreReplicatedContentMarshal serializer;

        ReplicatedContentMarshaller(CoreReplicatedContentMarshal serializer) {
            this.serializer = serializer;
        }

        @Override
        public void marshal(ReplicatedContent replicatedContent, WritableChannel channel) throws IOException {
            replicatedContent.handle(new MarshallingHandlerReplicated(channel));
        }

        @Override
        protected ReplicatedContent unmarshal0(ReadableChannel channel) throws IOException, EndOfStreamException {
            byte type = channel.get();
            ContentBuilder contentBuilder = this.serializer.unmarshal(type, channel);
            while (!contentBuilder.isComplete()) {
                type = channel.get();
                contentBuilder = contentBuilder.combine(this.serializer.unmarshal(type, channel));
            }
            return (ReplicatedContent)contentBuilder.build();
        }
    }

    private static class ReplicatedContentCodec
    implements Codec<ReplicatedContent> {
        private final CoreReplicatedContentMarshal serializer;

        ReplicatedContentCodec(CoreReplicatedContentMarshal serializer) {
            this.serializer = serializer;
        }

        @Override
        public void encode(ReplicatedContent type, List<Object> output) throws IOException {
            type.handle(new EncodingHandlerReplicated(output));
        }

        @Override
        public ContentBuilder<ReplicatedContent> decode(ByteBuf byteBuf) throws IOException, EndOfStreamException {
            return this.serializer.unmarshal(byteBuf.readByte(), byteBuf);
        }
    }
}

