/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.decoding;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.time.Clock;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.v2.decoding.RaftLogEntryTermsDecoder;
import org.neo4j.causalclustering.messaging.marshalling.v2.decoding.RaftMessageDecoder;

public class RaftMessageComposer
extends MessageToMessageDecoder<Object> {
    private final Queue<ReplicatedContent> replicatedContents = new LinkedList<ReplicatedContent>();
    private final Queue<Long> raftLogEntryTerms = new LinkedList<Long>();
    private RaftMessageDecoder.ClusterIdAwareMessageComposer messageComposer;
    private final Clock clock;

    public RaftMessageComposer(Clock clock) {
        this.clock = clock;
    }

    protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) {
        if (msg instanceof ReplicatedContent) {
            this.replicatedContents.add((ReplicatedContent)msg);
        } else if (msg instanceof RaftLogEntryTermsDecoder.RaftLogEntryTerms) {
            for (long term : ((RaftLogEntryTermsDecoder.RaftLogEntryTerms)msg).terms()) {
                this.raftLogEntryTerms.add(term);
            }
        } else if (msg instanceof RaftMessageDecoder.ClusterIdAwareMessageComposer) {
            if (this.messageComposer != null) {
                throw new IllegalStateException("Received raft message header. Pipeline already contains message header waiting to build.");
            }
            this.messageComposer = (RaftMessageDecoder.ClusterIdAwareMessageComposer)msg;
        } else {
            throw new IllegalStateException("Unexpected object in the pipeline: " + msg);
        }
        if (this.messageComposer != null) {
            Optional<RaftMessages.ClusterIdAwareMessage> clusterIdAwareMessage = this.messageComposer.maybeCompose(this.clock, this.raftLogEntryTerms, this.replicatedContents);
            clusterIdAwareMessage.ifPresent(message -> {
                this.clear((RaftMessages.ClusterIdAwareMessage)message);
                out.add(message);
            });
        }
    }

    private void clear(RaftMessages.ClusterIdAwareMessage message) {
        this.messageComposer = null;
        if (!this.replicatedContents.isEmpty() || !this.raftLogEntryTerms.isEmpty()) {
            throw new IllegalStateException(String.format("Message [%s] was composed without using all resources in the pipeline. Pipeline still contains Replicated contents[%s] and RaftLogEntryTerms [%s]", message, this.stringify(this.replicatedContents), this.stringify(this.raftLogEntryTerms)));
        }
    }

    private String stringify(Iterable<?> objects) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<?> iterator = objects.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }
}

