/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.decoding;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.neo4j.causalclustering.core.replication.ReplicatedContent;
import org.neo4j.causalclustering.messaging.marshalling.Codec;
import org.neo4j.causalclustering.messaging.marshalling.CoreReplicatedContentMarshal;

public class ReplicatedContentChunkDecoder
extends ByteToMessageDecoder {
    private final Codec<ReplicatedContent> codec = CoreReplicatedContentMarshal.codec();
    private boolean expectingNewContent = true;
    private boolean isLast;

    ReplicatedContentChunkDecoder() {
        this.setCumulator(new ContentChunkCumulator());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (this.expectingNewContent) {
            this.isLast = in.readBoolean();
            this.expectingNewContent = false;
        }
        if (this.isLast) {
            out.add(this.codec.decode(in));
            this.isLast = false;
            this.expectingNewContent = true;
        }
    }

    private class ContentChunkCumulator
    implements ByteToMessageDecoder.Cumulator {
        private ContentChunkCumulator() {
        }

        public ByteBuf cumulate(ByteBufAllocator alloc, ByteBuf cumulation, ByteBuf in) {
            ReplicatedContentChunkDecoder.this.isLast = in.readBoolean();
            return ByteToMessageDecoder.COMPOSITE_CUMULATOR.cumulate(alloc, cumulation, in);
        }
    }
}

