/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.encoding;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.neo4j.causalclustering.core.consensus.log.RaftLogEntry;
import org.neo4j.causalclustering.messaging.marshalling.v2.ContentType;

class RaftLogEntryTermsSerializer {
    RaftLogEntryTermsSerializer() {
    }

    static ByteBuf serializeTerms(RaftLogEntry[] raftLogEntries, ByteBufAllocator byteBufAllocator) {
        int capacity = 40 + 64 * raftLogEntries.length;
        ByteBuf buffer = byteBufAllocator.buffer(capacity, capacity);
        buffer.writeByte((int)ContentType.RaftLogEntryTerms.get());
        buffer.writeInt(raftLogEntries.length);
        for (RaftLogEntry raftLogEntry : raftLogEntries) {
            buffer.writeLong(raftLogEntry.term());
        }
        return buffer;
    }
}

