/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.messaging.marshalling.v2.encoding;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import org.neo4j.causalclustering.core.consensus.RaftMessages;
import org.neo4j.causalclustering.identity.ClusterId;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.messaging.NetworkWritableChannel;
import org.neo4j.causalclustering.messaging.marshalling.v2.ContentType;
import org.neo4j.storageengine.api.WritableChannel;

public class RaftMessageEncoder
extends MessageToByteEncoder<RaftMessages.ClusterIdAwareMessage> {
    protected void encode(ChannelHandlerContext ctx, RaftMessages.ClusterIdAwareMessage decoratedMessage, ByteBuf out) throws Exception {
        Object message = decoratedMessage.message();
        ClusterId clusterId = decoratedMessage.clusterId();
        MemberId.Marshal memberMarshal = new MemberId.Marshal();
        NetworkWritableChannel channel = new NetworkWritableChannel(out);
        channel.put(ContentType.Message.get());
        ClusterId.Marshal.INSTANCE.marshal(clusterId, (WritableChannel)channel);
        channel.putInt(message.type().ordinal());
        memberMarshal.marshal(message.from(), (WritableChannel)channel);
        message.dispatch(new Handler(memberMarshal, channel));
    }

    private static class Handler
    implements RaftMessages.Handler<Void, Exception> {
        private final MemberId.Marshal memberMarshal;
        private final NetworkWritableChannel channel;

        Handler(MemberId.Marshal memberMarshal, NetworkWritableChannel channel) {
            this.memberMarshal = memberMarshal;
            this.channel = channel;
        }

        @Override
        public Void handle(RaftMessages.Vote.Request voteRequest) throws Exception {
            this.memberMarshal.marshal(voteRequest.candidate(), (WritableChannel)this.channel);
            this.channel.putLong(voteRequest.term());
            this.channel.putLong(voteRequest.lastLogIndex());
            this.channel.putLong(voteRequest.lastLogTerm());
            return null;
        }

        @Override
        public Void handle(RaftMessages.Vote.Response voteResponse) {
            this.channel.putLong(voteResponse.term());
            this.channel.put((byte)(voteResponse.voteGranted() ? 1 : 0));
            return null;
        }

        @Override
        public Void handle(RaftMessages.PreVote.Request preVoteRequest) throws Exception {
            this.memberMarshal.marshal(preVoteRequest.candidate(), (WritableChannel)this.channel);
            this.channel.putLong(preVoteRequest.term());
            this.channel.putLong(preVoteRequest.lastLogIndex());
            this.channel.putLong(preVoteRequest.lastLogTerm());
            return null;
        }

        @Override
        public Void handle(RaftMessages.PreVote.Response preVoteResponse) {
            this.channel.putLong(preVoteResponse.term());
            this.channel.put((byte)(preVoteResponse.voteGranted() ? 1 : 0));
            return null;
        }

        @Override
        public Void handle(RaftMessages.AppendEntries.Request appendRequest) throws Exception {
            this.channel.putLong(appendRequest.leaderTerm());
            this.channel.putLong(appendRequest.prevLogIndex());
            this.channel.putLong(appendRequest.prevLogTerm());
            this.channel.putLong(appendRequest.leaderCommit());
            this.channel.putInt(appendRequest.entries().length);
            return null;
        }

        @Override
        public Void handle(RaftMessages.AppendEntries.Response appendResponse) {
            this.channel.putLong(appendResponse.term());
            this.channel.put((byte)(appendResponse.success() ? 1 : 0));
            this.channel.putLong(appendResponse.matchIndex());
            this.channel.putLong(appendResponse.appendIndex());
            return null;
        }

        @Override
        public Void handle(RaftMessages.NewEntry.Request newEntryRequest) throws Exception {
            return null;
        }

        @Override
        public Void handle(RaftMessages.Heartbeat heartbeat) {
            this.channel.putLong(heartbeat.leaderTerm());
            this.channel.putLong(heartbeat.commitIndexTerm());
            this.channel.putLong(heartbeat.commitIndex());
            return null;
        }

        @Override
        public Void handle(RaftMessages.HeartbeatResponse heartbeatResponse) {
            return null;
        }

        @Override
        public Void handle(RaftMessages.LogCompactionInfo logCompactionInfo) {
            this.channel.putLong(logCompactionInfo.leaderTerm());
            this.channel.putLong(logCompactionInfo.prevIndex());
            return null;
        }

        @Override
        public Void handle(RaftMessages.Timeout.Election election) {
            return null;
        }

        @Override
        public Void handle(RaftMessages.Timeout.Heartbeat heartbeat) {
            return null;
        }

        @Override
        public Void handle(RaftMessages.NewEntry.BatchRequest batchRequest) {
            return null;
        }

        @Override
        public Void handle(RaftMessages.PruneRequest pruneRequest) {
            return null;
        }
    }
}

