/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.function.BiConsumer;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.BaseProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolRequest;
import org.neo4j.causalclustering.protocol.handshake.ServerMessage;
import org.neo4j.causalclustering.protocol.handshake.ServerMessageHandler;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverRequest;

public class ClientMessageEncoder
extends MessageToByteEncoder<ServerMessage> {
    protected void encode(ChannelHandlerContext ctx, ServerMessage msg, ByteBuf out) {
        msg.dispatch(new Encoder(out));
    }

    class Encoder
    implements ServerMessageHandler {
        private final ByteBuf out;

        Encoder(ByteBuf out) {
            this.out = out;
        }

        @Override
        public void handle(InitialMagicMessage magicMessage) {
            this.out.writeInt(877610318);
            StringMarshal.marshal(this.out, magicMessage.magic());
        }

        @Override
        public void handle(ApplicationProtocolRequest applicationProtocolRequest) {
            this.out.writeInt(1);
            this.encodeProtocolRequest(applicationProtocolRequest, ByteBuf::writeInt);
        }

        @Override
        public void handle(ModifierProtocolRequest modifierProtocolRequest) {
            this.out.writeInt(2);
            this.encodeProtocolRequest(modifierProtocolRequest, StringMarshal::marshal);
        }

        @Override
        public void handle(SwitchOverRequest switchOverRequest) {
            this.out.writeInt(3);
            StringMarshal.marshal(this.out, switchOverRequest.protocolName());
            this.out.writeInt(switchOverRequest.version());
            this.out.writeInt(switchOverRequest.modifierProtocols().size());
            switchOverRequest.modifierProtocols().forEach(pair -> {
                StringMarshal.marshal(this.out, (String)pair.first());
                StringMarshal.marshal(this.out, (String)pair.other());
            });
        }

        private <U extends Comparable<U>> void encodeProtocolRequest(BaseProtocolRequest<U> protocolRequest, BiConsumer<ByteBuf, U> writer) {
            StringMarshal.marshal(this.out, protocolRequest.protocolName());
            this.out.writeInt(protocolRequest.versions().size());
            protocolRequest.versions().forEach(version -> writer.accept(this.out, version));
        }
    }
}

