/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.causalclustering.protocol.Protocol;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolSelection;
import org.neo4j.causalclustering.protocol.handshake.ModifierSupportedProtocols;
import org.neo4j.causalclustering.protocol.handshake.ProtocolRepository;
import org.neo4j.causalclustering.protocol.handshake.SupportedProtocols;

public class ModifierProtocolRepository
extends ProtocolRepository<String, Protocol.ModifierProtocol> {
    private final Collection<ModifierSupportedProtocols> supportedProtocols;
    private final Map<String, ModifierSupportedProtocols> supportedProtocolsLookup;

    public ModifierProtocolRepository(Protocol.ModifierProtocol[] protocols, Collection<ModifierSupportedProtocols> supportedProtocols) {
        super((Protocol[])protocols, ModifierProtocolRepository.getModifierProtocolComparator(supportedProtocols), ModifierProtocolSelection::new);
        this.supportedProtocols = Collections.unmodifiableCollection(supportedProtocols);
        this.supportedProtocolsLookup = supportedProtocols.stream().collect(Collectors.toMap(supp -> supp.identifier().canonicalName(), Function.identity()));
    }

    static Function<String, Comparator<Protocol.ModifierProtocol>> getModifierProtocolComparator(Collection<ModifierSupportedProtocols> supportedProtocols) {
        return ModifierProtocolRepository.getModifierProtocolComparator(ModifierProtocolRepository.versionMap(supportedProtocols));
    }

    private static Map<String, List<String>> versionMap(Collection<ModifierSupportedProtocols> supportedProtocols) {
        return supportedProtocols.stream().collect(Collectors.toMap(supportedProtocol -> supportedProtocol.identifier().canonicalName(), SupportedProtocols::versions));
    }

    private static Function<String, Comparator<Protocol.ModifierProtocol>> getModifierProtocolComparator(Map<String, List<String>> versionMap) {
        return protocolName -> {
            Comparator<Protocol.ModifierProtocol> positionalComparator = Comparator.comparing(modifierProtocol -> Optional.ofNullable(versionMap.get(protocolName)).map(versions -> ModifierProtocolRepository.byPosition(modifierProtocol, versions)).orElse(0));
            return ModifierProtocolRepository.fallBackToVersionNumbers(positionalComparator);
        };
    }

    private static Comparator<Protocol.ModifierProtocol> fallBackToVersionNumbers(Comparator<Protocol.ModifierProtocol> positionalComparator) {
        return positionalComparator.thenComparing(ModifierProtocolRepository.versionNumberComparator());
    }

    private static Integer byPosition(Protocol.ModifierProtocol modifierProtocol, List<String> versions) {
        int index = versions.indexOf(modifierProtocol.implementation());
        return index == -1 ? Integer.MIN_VALUE : -index;
    }

    public Optional<SupportedProtocols<String, Protocol.ModifierProtocol>> supportedProtocolFor(String protocolName) {
        return Optional.ofNullable(this.supportedProtocolsLookup.get(protocolName));
    }

    public Collection<ModifierSupportedProtocols> supportedProtocols() {
        return this.supportedProtocols;
    }
}

