/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.protocol.handshake;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToByteEncoder;
import java.util.function.BiConsumer;
import org.neo4j.causalclustering.messaging.marshalling.StringMarshal;
import org.neo4j.causalclustering.protocol.handshake.ApplicationProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.BaseProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.ClientMessage;
import org.neo4j.causalclustering.protocol.handshake.ClientMessageHandler;
import org.neo4j.causalclustering.protocol.handshake.InitialMagicMessage;
import org.neo4j.causalclustering.protocol.handshake.ModifierProtocolResponse;
import org.neo4j.causalclustering.protocol.handshake.SwitchOverResponse;

public class ServerMessageEncoder
extends MessageToByteEncoder<ClientMessage> {
    protected void encode(ChannelHandlerContext ctx, ClientMessage msg, ByteBuf out) {
        msg.dispatch(new Encoder(out));
    }

    class Encoder
    implements ClientMessageHandler {
        private final ByteBuf out;

        Encoder(ByteBuf out) {
            this.out = out;
        }

        @Override
        public void handle(InitialMagicMessage magicMessage) {
            this.out.writeInt(877610318);
            StringMarshal.marshal(this.out, magicMessage.magic());
        }

        @Override
        public void handle(ApplicationProtocolResponse applicationProtocolResponse) {
            this.out.writeInt(0);
            this.encodeProtocolResponse(applicationProtocolResponse, ByteBuf::writeInt);
        }

        @Override
        public void handle(ModifierProtocolResponse modifierProtocolResponse) {
            this.out.writeInt(1);
            this.encodeProtocolResponse(modifierProtocolResponse, StringMarshal::marshal);
        }

        @Override
        public void handle(SwitchOverResponse switchOverResponse) {
            this.out.writeInt(2);
            this.out.writeInt(switchOverResponse.status().codeValue());
        }

        private <U extends Comparable<U>> void encodeProtocolResponse(BaseProtocolResponse<U> protocolResponse, BiConsumer<ByteBuf, U> writer) {
            this.out.writeInt(protocolResponse.statusCode().codeValue());
            StringMarshal.marshal(this.out, protocolResponse.protocolName());
            writer.accept(this.out, protocolResponse.version());
        }
    }
}

