/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.load_balancing;

import java.util.HashSet;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.core.consensus.LeaderLocator;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingPlugin;
import org.neo4j.causalclustering.routing.load_balancing.LoadBalancingProcessor;
import org.neo4j.causalclustering.routing.load_balancing.plugins.ServerShufflingProcessor;
import org.neo4j.graphdb.config.InvalidSettingException;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public class LoadBalancingPluginLoader {
    private LoadBalancingPluginLoader() {
    }

    public static void validate(Config config, Log log) throws InvalidSettingException {
        LoadBalancingPlugin plugin = LoadBalancingPluginLoader.findPlugin(config);
        plugin.validate(config, log);
    }

    public static LoadBalancingProcessor load(TopologyService topologyService, LeaderLocator leaderLocator, LogProvider logProvider, Config config) throws Throwable {
        LoadBalancingPlugin plugin = LoadBalancingPluginLoader.findPlugin(config);
        plugin.init(topologyService, leaderLocator, logProvider, config);
        if (((Boolean)config.get(CausalClusteringSettings.load_balancing_shuffle)).booleanValue() && !plugin.isShufflingPlugin()) {
            return new ServerShufflingProcessor(plugin);
        }
        return plugin;
    }

    private static LoadBalancingPlugin findPlugin(Config config) throws InvalidSettingException {
        HashSet<String> availableOptions = new HashSet<String>();
        Iterable allImplementationsOnClasspath = Service.load(LoadBalancingPlugin.class);
        String configuredName = (String)config.get(CausalClusteringSettings.load_balancing_plugin);
        for (LoadBalancingPlugin plugin : allImplementationsOnClasspath) {
            if (plugin.pluginName().equals(configuredName)) {
                return plugin;
            }
            availableOptions.add(plugin.pluginName());
        }
        throw new InvalidSettingException(String.format("Could not find load balancing plugin with name: '%s' among available options: %s", configuredName, availableOptions));
    }
}

