/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.multi_cluster;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.RoutingResult;

public class MultiClusterRoutingResult
implements RoutingResult {
    private final Map<String, List<Endpoint>> routers;
    private final long timeToLiveMillis;

    public MultiClusterRoutingResult(Map<String, List<Endpoint>> routers, long timeToLiveMillis) {
        this.routers = routers;
        this.timeToLiveMillis = timeToLiveMillis;
    }

    public Map<String, List<Endpoint>> routers() {
        return this.routers;
    }

    @Override
    public long ttlMillis() {
        return this.timeToLiveMillis;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiClusterRoutingResult that = (MultiClusterRoutingResult)o;
        return this.timeToLiveMillis == that.timeToLiveMillis && Objects.equals(this.routers, that.routers);
    }

    public int hashCode() {
        return Objects.hash(this.routers, this.timeToLiveMillis);
    }
}

