/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.routing.multi_cluster.procedure;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.CoreServerInfo;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.routing.Endpoint;
import org.neo4j.causalclustering.routing.Util;
import org.neo4j.causalclustering.routing.multi_cluster.MultiClusterRoutingResult;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.MultiClusterRoutingResultFormat;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.ParameterNames;
import org.neo4j.causalclustering.routing.multi_cluster.procedure.ProcedureNames;
import org.neo4j.collection.RawIterator;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.proc.CallableProcedure;
import org.neo4j.kernel.api.proc.Context;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.procedure.Mode;

public class GetRoutersForDatabaseProcedure
implements CallableProcedure {
    private static final String DESCRIPTION = "Returns router capable endpoints for a specific database in a multi-cluster.";
    private final ProcedureSignature procedureSignature = ProcedureSignature.procedureSignature((String[])ProcedureNames.GET_ROUTERS_FOR_DATABASE.fullyQualifiedProcedureName()).in(ParameterNames.DATABASE.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTString).out(ParameterNames.TTL.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out(ParameterNames.ROUTERS.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)).mode(Mode.DBMS).description("Returns router capable endpoints for a specific database in a multi-cluster.").build();
    private final TopologyService topologyService;
    private final long timeToLiveMillis;

    public GetRoutersForDatabaseProcedure(TopologyService topologyService, Config config) {
        this.topologyService = topologyService;
        this.timeToLiveMillis = ((Duration)config.get(CausalClusteringSettings.cluster_routing_ttl)).toMillis();
    }

    public ProcedureSignature signature() {
        return this.procedureSignature;
    }

    public RawIterator<Object[], ProcedureException> apply(Context ctx, Object[] input, ResourceTracker resourceTracker) throws ProcedureException {
        String dbName = (String)input[0];
        List<Endpoint> routers = this.routeEndpoints(dbName);
        HashMap<String, List<Endpoint>> routerMap = new HashMap<String, List<Endpoint>>();
        routerMap.put(dbName, routers);
        MultiClusterRoutingResult result = new MultiClusterRoutingResult(routerMap, this.timeToLiveMillis);
        return RawIterator.of((Object[])new Object[][]{MultiClusterRoutingResultFormat.build(result)});
    }

    private List<Endpoint> routeEndpoints(String dbName) {
        CoreTopology filtered = this.topologyService.allCoreServers().filterTopologyByDb(dbName);
        Stream<CoreServerInfo> filteredCoreMemberInfo = filtered.members().values().stream();
        return filteredCoreMemberInfo.map(Util.extractBoltAddress()).map(Endpoint::route).collect(Collectors.toList());
    }
}

