/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream;

import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.neo4j.causalclustering.core.CausalClusteringSettings;
import org.neo4j.causalclustering.discovery.TopologyService;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.helpers.Service;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;

public abstract class UpstreamDatabaseSelectionStrategy
extends Service {
    protected TopologyService topologyService;
    protected Config config;
    protected Log log;
    protected MemberId myself;
    protected String readableName;
    protected String dbName;

    public UpstreamDatabaseSelectionStrategy(String key, String ... altKeys) {
        super(key, altKeys);
    }

    public void inject(TopologyService topologyService, Config config, LogProvider logProvider, MemberId myself) {
        this.topologyService = topologyService;
        this.config = config;
        this.log = logProvider.getLog(((Object)((Object)this)).getClass());
        this.myself = myself;
        this.dbName = (String)config.get(CausalClusteringSettings.database);
        this.readableName = StreamSupport.stream(this.getKeys().spliterator(), false).collect(Collectors.joining(", "));
        this.log.info("Using upstream selection strategy " + this.readableName);
        this.init();
    }

    public void init() {
    }

    public abstract Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException;

    public String toString() {
        return UpstreamDatabaseSelectionStrategy.nicelyCommaSeparatedList(this.getKeys());
    }

    private static String nicelyCommaSeparatedList(Iterable<String> keys) {
        return StreamSupport.stream(keys.spliterator(), false).collect(Collectors.joining(", "));
    }
}

