/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream;

import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.NullLogProvider;

public class UpstreamDatabaseStrategySelector {
    private LinkedHashSet<UpstreamDatabaseSelectionStrategy> strategies = new LinkedHashSet();
    private Log log;

    public UpstreamDatabaseStrategySelector(UpstreamDatabaseSelectionStrategy defaultStrategy) {
        this(defaultStrategy, Iterables.empty(), (LogProvider)NullLogProvider.getInstance());
    }

    public UpstreamDatabaseStrategySelector(UpstreamDatabaseSelectionStrategy defaultStrategy, Iterable<UpstreamDatabaseSelectionStrategy> otherStrategies, LogProvider logProvider) {
        this.log = logProvider.getLog(this.getClass());
        if (otherStrategies != null) {
            for (UpstreamDatabaseSelectionStrategy otherStrategy : otherStrategies) {
                this.strategies.add(otherStrategy);
            }
        }
        this.strategies.add(defaultStrategy);
    }

    public MemberId bestUpstreamDatabase() throws UpstreamDatabaseSelectionException {
        MemberId result = null;
        for (UpstreamDatabaseSelectionStrategy strategy : this.strategies) {
            this.log.debug("Trying selection strategy [%s]", new Object[]{strategy.toString()});
            try {
                if (!strategy.upstreamDatabase().isPresent()) continue;
                result = strategy.upstreamDatabase().get();
                break;
            }
            catch (NoSuchElementException noSuchElementException) {
            }
        }
        if (result == null) {
            throw new UpstreamDatabaseSelectionException("Could not find an upstream database with which to connect.");
        }
        this.log.debug("Selected upstream database [%s]", new Object[]{result});
        return result;
    }
}

