/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.causalclustering.upstream.strategies;

import java.util.Optional;
import java.util.Random;
import org.neo4j.causalclustering.discovery.CoreTopology;
import org.neo4j.causalclustering.identity.MemberId;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionException;
import org.neo4j.causalclustering.upstream.UpstreamDatabaseSelectionStrategy;

public class ConnectToRandomCoreServerStrategy
extends UpstreamDatabaseSelectionStrategy {
    public static final String IDENTITY = "connect-to-random-core-server";
    private final Random random = new Random();

    public ConnectToRandomCoreServerStrategy() {
        super(IDENTITY, new String[0]);
    }

    @Override
    public Optional<MemberId> upstreamDatabase() throws UpstreamDatabaseSelectionException {
        CoreTopology coreTopology = this.topologyService.localCoreServers();
        if (coreTopology.members().size() == 0) {
            throw new UpstreamDatabaseSelectionException("No core servers available");
        }
        int skippedServers = this.random.nextInt(coreTopology.members().size());
        return coreTopology.members().keySet().stream().skip(skippedServers).findFirst();
    }
}

