/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaciton.monitor;

import java.time.Clock;
import java.util.Set;
import org.neo4j.kernel.api.KernelTransactionHandle;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.logging.Log;
import org.neo4j.logging.internal.LogService;

public class KernelTransactionMonitor
implements Runnable {
    private final KernelTransactions kernelTransactions;
    private final Clock clock;
    private final Log log;

    public KernelTransactionMonitor(KernelTransactions kernelTransactions, Clock clock, LogService logService) {
        this.kernelTransactions = kernelTransactions;
        this.clock = clock;
        this.log = logService.getInternalLog(KernelTransactionMonitor.class);
    }

    @Override
    public synchronized void run() {
        long now = this.clock.millis();
        Set<KernelTransactionHandle> activeTransactions = this.kernelTransactions.activeTransactions();
        this.checkExpiredTransactions(activeTransactions, now);
    }

    private void checkExpiredTransactions(Set<KernelTransactionHandle> activeTransactions, long now) {
        for (KernelTransactionHandle activeTransaction : activeTransactions) {
            long transactionTimeoutMillis = activeTransaction.timeoutMillis();
            if (transactionTimeoutMillis <= 0L || !KernelTransactionMonitor.isTransactionExpired(activeTransaction, now, transactionTimeoutMillis) || activeTransaction.isSchemaTransaction() || !activeTransaction.markForTermination((Status)Status.Transaction.TransactionTimedOut)) continue;
            this.log.warn("Transaction %s timeout.", new Object[]{activeTransaction});
        }
    }

    private static boolean isTransactionExpired(KernelTransactionHandle activeTransaction, long nowMillis, long transactionTimeoutMillis) {
        return nowMillis > activeTransaction.startTime() + transactionTimeoutMillis;
    }
}

