/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.labelscan;

import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.graphdb.ResourceUtils;

class CompositeLabelScanValueIterator
extends PrimitiveLongCollections.PrimitiveLongBaseIterator
implements PrimitiveLongResourceIterator {
    private final PriorityQueue<IdAndSource> sortedIterators = new PriorityQueue();
    private final int atLeastNumberOfLabels;
    private final List<PrimitiveLongResourceIterator> toClose;
    private long last = -1L;

    CompositeLabelScanValueIterator(List<PrimitiveLongResourceIterator> iterators, boolean trueForAll) {
        this.toClose = iterators;
        this.atLeastNumberOfLabels = trueForAll ? iterators.size() : 1;
        for (LongIterator longIterator : iterators) {
            if (!longIterator.hasNext()) continue;
            this.sortedIterators.add(new IdAndSource(longIterator.next(), longIterator));
        }
    }

    protected boolean fetchNext() {
        int numberOfLabels = 0;
        long next = this.last;
        while (next == this.last || numberOfLabels < this.atLeastNumberOfLabels) {
            IdAndSource idAndSource = this.sortedIterators.poll();
            if (idAndSource == null) {
                return false;
            }
            if (idAndSource.latestReturned == next) {
                ++numberOfLabels;
            } else {
                next = idAndSource.latestReturned;
                numberOfLabels = 1;
            }
            if (!idAndSource.source.hasNext()) continue;
            idAndSource.latestReturned = idAndSource.source.next();
            this.sortedIterators.offer(idAndSource);
        }
        this.last = next;
        this.next(this.last);
        return true;
    }

    public void close() {
        ResourceUtils.closeAll(this.toClose);
        this.sortedIterators.clear();
        this.toClose.clear();
    }

    private static class IdAndSource
    implements Comparable<IdAndSource> {
        private long latestReturned;
        private final LongIterator source;

        private IdAndSource(long latestReturned, LongIterator source) {
            this.latestReturned = latestReturned;
            this.source = source;
        }

        @Override
        public int compareTo(IdAndSource o) {
            int keyComparison = Long.compare(this.latestReturned, o.latestReturned);
            if (keyComparison == 0) {
                return Integer.compare(this.source.hashCode(), o.source.hashCode());
            }
            return keyComparison;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IdAndSource that = (IdAndSource)o;
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.latestReturned, this.source);
        }
    }
}

