/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.index.internal.gbptree.ValueMerger;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

abstract class ConflictDetectingValueMerger<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue, REPORT_TYPE>
implements ValueMerger<KEY, VALUE> {
    private final boolean compareEntityIds;
    private boolean conflict;
    private long existingNodeId;
    private long addedNodeId;

    ConflictDetectingValueMerger(boolean compareEntityIds) {
        this.compareEntityIds = compareEntityIds;
    }

    public VALUE merge(KEY existingKey, KEY newKey, VALUE existingValue, VALUE newValue) {
        if (((NativeIndexKey)((Object)existingKey)).getEntityId() != ((NativeIndexKey)((Object)newKey)).getEntityId()) {
            this.conflict = true;
            this.existingNodeId = ((NativeIndexKey)((Object)existingKey)).getEntityId();
            this.addedNodeId = ((NativeIndexKey)((Object)newKey)).getEntityId();
        }
        return null;
    }

    void controlConflictDetection(KEY key) {
        ((NativeIndexKey)((Object)key)).setCompareId(this.compareEntityIds);
    }

    boolean wasConflicting() {
        return this.conflict;
    }

    void reportConflict(REPORT_TYPE toReport) throws IndexEntryConflictException {
        this.conflict = false;
        this.doReportConflict(this.existingNodeId, this.addedNodeId, toReport);
    }

    void checkConflict(REPORT_TYPE toReport) throws IndexEntryConflictException {
        if (this.wasConflicting()) {
            this.reportConflict(toReport);
        }
    }

    abstract void doReportConflict(long var1, long var3, REPORT_TYPE var5) throws IndexEntryConflictException;
}

