/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.time.LocalDate;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

class DateType
extends Type {
    DateType(byte typeId) {
        super(ValueGroup.DATE, typeId, (Value)DateValue.MIN_VALUE, (Value)DateValue.MAX_VALUE);
    }

    @Override
    int valueSize(GenericKey state) {
        return 8;
    }

    @Override
    void copyValue(GenericKey to, GenericKey from) {
        to.long0 = from.long0;
    }

    @Override
    Value asValue(GenericKey state) {
        return DateType.asValue(state.long0);
    }

    @Override
    int compareValue(GenericKey left, GenericKey right) {
        return DateType.compare(left.long0, right.long0);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey state) {
        DateType.put(cursor, state.long0);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey into) {
        return DateType.read(cursor, into);
    }

    static DateValue asValue(long long0) {
        return DateValue.date((LocalDate)DateType.asValueRaw(long0));
    }

    static LocalDate asValueRaw(long long0) {
        return DateValue.epochDateRaw((long)long0);
    }

    static int compare(long this_long0, long that_long0) {
        return Long.compare(this_long0, that_long0);
    }

    static void put(PageCursor cursor, long long0) {
        cursor.putLong(long0);
    }

    static boolean read(PageCursor cursor, GenericKey into) {
        into.writeDate(cursor.getLong());
        return true;
    }

    void write(GenericKey state, long epochDay) {
        state.long0 = epochDay;
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey state) {
        joiner.add("long0=" + state.long0);
    }
}

