/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.impl.index.schema.IndexDropAction;
import org.neo4j.kernel.impl.index.schema.NativeIndexes;

public class FileSystemIndexDropAction
implements IndexDropAction {
    private final FileSystemAbstraction fs;
    private final IndexDirectoryStructure directoryStructure;

    public FileSystemIndexDropAction(FileSystemAbstraction fs, IndexDirectoryStructure directoryStructure) {
        this.fs = fs;
        this.directoryStructure = directoryStructure;
    }

    @Override
    public void drop(long indexId, boolean archiveExistentIndex) {
        try {
            NativeIndexes.deleteIndex(this.fs, this.directoryStructure, indexId, archiveExistentIndex);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

