/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.internal.kernel.api.IndexReference;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.SchemaReadCore;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.schema.SchemaDescriptor;
import org.neo4j.internal.kernel.api.schema.constraints.ConstraintDescriptor;
import org.neo4j.kernel.impl.api.KernelTransactionImplementation;
import org.neo4j.kernel.impl.newapi.AllStoreHolder;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.schema.IndexDescriptor;
import org.neo4j.storageengine.api.schema.PopulationProgress;

class SchemaReadCoreSnapshot
implements SchemaReadCore {
    private final StorageSchemaReader snapshot;
    private final KernelTransactionImplementation ktx;
    private final AllStoreHolder stores;

    SchemaReadCoreSnapshot(StorageSchemaReader snapshot, KernelTransactionImplementation ktx, AllStoreHolder stores) {
        this.snapshot = snapshot;
        this.ktx = ktx;
        this.stores = stores;
    }

    public IndexReference index(SchemaDescriptor schema) {
        this.ktx.assertOpen();
        return this.stores.indexGetForSchema(this.snapshot, schema);
    }

    public Iterator<IndexReference> indexesGetForLabel(int labelId) {
        this.ktx.assertOpen();
        return this.stores.indexesGetForLabel(this.snapshot, labelId);
    }

    public Iterator<IndexReference> indexesGetForRelationshipType(int relationshipType) {
        this.ktx.assertOpen();
        return this.stores.indexesGetForRelationshipType(this.snapshot, relationshipType);
    }

    public Iterator<IndexReference> indexesGetAll() {
        this.ktx.assertOpen();
        return this.stores.indexesGetAll(this.snapshot);
    }

    public InternalIndexState indexGetState(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.ktx.assertOpen();
        return this.stores.indexGetState(this.snapshot, (IndexDescriptor)index);
    }

    public PopulationProgress indexGetPopulationProgress(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        this.ktx.assertOpen();
        return this.stores.indexGetPopulationProgress(this.snapshot, index);
    }

    public String indexGetFailure(IndexReference index) throws IndexNotFoundKernelException {
        AllStoreHolder.assertValidIndex(index);
        return this.snapshot.indexGetFailure(index.schema());
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        this.ktx.assertOpen();
        return this.stores.constraintsGetForLabel(this.snapshot, labelId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        this.ktx.assertOpen();
        return this.stores.constraintsGetForRelationshipType(this.snapshot, typeId);
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        this.ktx.assertOpen();
        return this.stores.constraintsGetAll(this.snapshot);
    }
}

